/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;

public class AutoClosingException
extends RiskscapeException {
    private final List<Exception> failures;
    private final RealizedPipeline pipeline;

    public AutoClosingException(RealizedPipeline pipeline, List<Exception> failures) {
        super(String.format("Failed to close all resources attached to %s - There were %d exceptions", pipeline, failures.size()));
        this.pipeline = pipeline;
        this.failures = failures;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        for (Exception failure : this.failures) {
            failure.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        for (Exception failure : this.failures) {
            failure.printStackTrace(s);
        }
    }

    @Generated
    public List<Exception> getFailures() {
        return this.failures;
    }

    @Generated
    public RealizedPipeline getPipeline() {
        return this.pipeline;
    }
}

