/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.join;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.Unchecked;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;

public interface JoinCondition {
    public static final JoinCondition CARTESIAN = new JoinCondition(){

        @Override
        public List<Problem> validate(Struct joinedType) {
            return Collections.emptyList();
        }

        @Override
        public boolean matches(Tuple row) {
            return true;
        }

        public String toString() {
            return "Cartesian";
        }
    };

    public static JoinCondition unchecked(final Predicate<Tuple> predicate) {
        return new JoinCondition(){

            @Override
            public List<Problem> validate(Struct joinedType) {
                return Arrays.asList(new Unchecked("unchecked predicate"));
            }

            @Override
            public boolean matches(Tuple row) {
                return predicate.apply((Object)row);
            }

            public String toString() {
                return "Unchecked - " + String.valueOf(predicate);
            }
        };
    }

    public boolean matches(Tuple var1);

    public List<Problem> validate(Struct var1);
}

