/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.i18n.MessageKey;

public class RiskscapeMessage
implements MessageKey {
    private final String code;
    private final Object[] messageArguments;
    private final String defaultMessage;

    public static RiskscapeMessage of(@NonNull String code, Object ... arguments) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return new RiskscapeMessage(code, arguments, null);
    }

    public static RiskscapeMessage withDefault(@NonNull String code, @NonNull String defaultMessage, Object ... arguments) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (defaultMessage == null) {
            throw new NullPointerException("defaultMessage is marked non-null but is null");
        }
        return new RiskscapeMessage(code, arguments, defaultMessage);
    }

    public static RiskscapeMessage ofDefault(@NonNull String defaultMessage, Object ... args) {
        if (defaultMessage == null) {
            throw new NullPointerException("defaultMessage is marked non-null but is null");
        }
        return new RiskscapeMessage("", args, defaultMessage);
    }

    private RiskscapeMessage(String code, Object[] messageArguments, String defaultMessage) {
        this.code = code;
        this.messageArguments = messageArguments != null ? messageArguments : new Object[]{};
        this.defaultMessage = defaultMessage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RiskscapeMessage)) {
            return false;
        }
        RiskscapeMessage other = (RiskscapeMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMessageArguments(), other.getMessageArguments())) {
            return false;
        }
        String this$defaultMessage = this.getDefaultMessage();
        String other$defaultMessage = other.getDefaultMessage();
        return !(this$defaultMessage == null ? other$defaultMessage != null : !this$defaultMessage.equals(other$defaultMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RiskscapeMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMessageArguments());
        String $defaultMessage = this.getDefaultMessage();
        result = result * 59 + ($defaultMessage == null ? 43 : $defaultMessage.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public Object[] getMessageArguments() {
        return this.messageArguments;
    }

    @Override
    @Generated
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}

