/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.problem.Problem;

public class RenderedProblem {
    private static final ToStringOptions DEFAULT_TO_STRING_OPTIONS = new ToStringOptions();
    public final String message;
    public final Problem source;
    public final int indentLevel;
    public final List<RenderedProblem> children;

    public RenderedProblem(String message, Problem source) {
        this(message, source, 0, Collections.emptyList());
    }

    public List<RenderedProblem> toList() {
        LinkedList<RenderedProblem> collected = new LinkedList<RenderedProblem>();
        this.addAll(collected);
        return collected;
    }

    private void addAll(LinkedList<RenderedProblem> collected) {
        collected.add(this);
        for (RenderedProblem renderedProblem : this.children) {
            renderedProblem.addAll(collected);
        }
    }

    public String toString(Consumer<ToStringOptions> customize) {
        return this.toString(new ToStringOptions(customize));
    }

    public String toString(ToStringOptions options) {
        List<RenderedProblem> problems = this.toList();
        StringBuilder builder = new StringBuilder();
        for (RenderedProblem renderedProblem : problems) {
            if (builder.length() != 0) {
                builder.append(options.separator);
            }
            builder.append(options.prefixAll);
            if (renderedProblem.indentLevel > 0) {
                for (int i = 0; i < renderedProblem.indentLevel; ++i) {
                    builder.append(options.indent);
                }
                builder.append(options.prefixChildren);
            }
            builder.append(renderedProblem.message);
        }
        builder.append(options.terminateWith);
        return builder.toString();
    }

    public String toString() {
        return this.toString(DEFAULT_TO_STRING_OPTIONS);
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Problem getSource() {
        return this.source;
    }

    @Generated
    public int getIndentLevel() {
        return this.indentLevel;
    }

    @Generated
    public List<RenderedProblem> getChildren() {
        return this.children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderedProblem)) {
            return false;
        }
        RenderedProblem other = (RenderedProblem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndentLevel() != other.getIndentLevel()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Problem this$source = this.getSource();
        Problem other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        List<RenderedProblem> this$children = this.getChildren();
        List<RenderedProblem> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RenderedProblem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndentLevel();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Problem $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        List<RenderedProblem> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public RenderedProblem(String message, Problem source, int indentLevel, List<RenderedProblem> children) {
        this.message = message;
        this.source = source;
        this.indentLevel = indentLevel;
        this.children = children;
    }

    public static class ToStringOptions {
        public String indent = "  ";
        public String prefixAll = "";
        public String prefixChildren = "- ";
        public String separator = OsUtils.LINE_SEPARATOR;
        public String terminateWith = "";

        public ToStringOptions() {
        }

        public ToStringOptions(Consumer<ToStringOptions> customize) {
            if (customize != null) {
                customize.accept(this);
            }
        }
    }
}

