/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.geo.GeometryFamily;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

@FunctionalInterface
public interface GeometryFixer {
    public static final GeometryFixer DEFAULT = new Base(geom -> org.locationtech.jts.geom.util.GeometryFixer.fix((Geometry)geom));

    public Geometry fix(Geometry var1);

    public static class Base
    implements GeometryFixer {
        private final Function<Geometry, Geometry> fixer;

        @Override
        public Geometry fix(Geometry geom) {
            GeometryFamily sourceFamily = GeometryFamily.from(geom);
            Geometry fixed = this.fixer.apply(geom);
            if (fixed.isEmpty()) {
                return null;
            }
            if (fixed instanceof GeometryCollection) {
                Geometry onlyItem;
                GeometryCollection collection = (GeometryCollection)fixed;
                GeometryFamily family = null;
                for (int i = 0; i < collection.getNumGeometries(); ++i) {
                    Geometry part = collection.getGeometryN(i);
                    if (family == null) {
                        family = GeometryFamily.from(part);
                        continue;
                    }
                    if (family.isSameFamily(part)) continue;
                    return null;
                }
                if (collection.getNumGeometries() == 1 && sourceFamily.isSameFamily(onlyItem = collection.getGeometryN(0))) {
                    return onlyItem;
                }
            } else if (!sourceFamily.isSameFamily(fixed)) {
                return null;
            }
            return fixed;
        }

        @Generated
        public Base(Function<Geometry, Geometry> fixer) {
            this.fixer = fixer;
        }
    }
}

