/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import lombok.Generated;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;

public enum GeometryFamily {
    PUNTAL(Puntal.class),
    LINEAL(Lineal.class),
    POLYGONAL(Polygonal.class);

    private Class<?> familyClass;

    public static GeometryFamily from(Geometry geometry) {
        return GeometryFamily.fromClass(geometry.getClass());
    }

    public static GeometryFamily fromClass(Class fromClass) {
        for (GeometryFamily family : GeometryFamily.values()) {
            if (!family.familyClass.isAssignableFrom(fromClass)) continue;
            return family;
        }
        return null;
    }

    private GeometryFamily(Class<?> clazz) {
        this.familyClass = clazz;
    }

    public GeometryFamily min(GeometryFamily rhs) {
        return this.ordinal() < rhs.ordinal() ? this : rhs;
    }

    public boolean isSameFamily(Geometry geom) {
        return this.familyClass.isAssignableFrom(geom.getClass());
    }

    @Generated
    public Class<?> getFamilyClass() {
        return this.familyClass;
    }
}

