/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.agg;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.PropertyAccess;

public class AggregationFunctionAdapter
implements RiskscapeFunction,
RealizableFunction {
    private final AggregationFunction aggfunction;

    @Override
    public Type getReturnType() {
        return this.aggfunction.getReturnType();
    }

    @Override
    public ArgumentList getArguments() {
        return this.aggfunction.getArguments();
    }

    @Override
    public List<Type> getArgumentTypes() {
        return this.getArguments().getArgumentTypes();
    }

    @Override
    public Object call(List<Object> args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<AggregationFunction> getAggregationFunction() {
        return Optional.of(this.aggfunction);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, final List<Type> argumentTypes) {
        if (argumentTypes.size() != this.getArgumentTypes().size()) {
            return ResultOrProblems.failed(ArgsProblems.get().wrongNumber(this.getArgumentTypes().size(), argumentTypes.size()));
        }
        return ProblemException.catching(() -> {
            RSList list = Types.findOrThrow(functionCall.getArguments().get(0), RSList.LIST_ANYTHING, (Type)argumentTypes.get(0));
            final Struct kludgedInputType = Struct.of("value", list.getContainedType());
            ArrayList<FunctionCall.Argument> kludgedFunctionCallArgs = new ArrayList<FunctionCall.Argument>(functionCall.getArguments());
            kludgedFunctionCallArgs.set(0, new FunctionCall.Argument(PropertyAccess.of("value")));
            FunctionCall kludgedFunctionCall = new FunctionCall(functionCall.getIdentifier(), kludgedFunctionCallArgs);
            final RealizedAggregateExpression resolvedSetFunction = this.aggfunction.realize(context, kludgedInputType, kludgedFunctionCall).getOrThrow();
            final Type returnType = Nullable.ifTrue(resolvedSetFunction.newAccumulator().isEmpty(), resolvedSetFunction.getResultType());
            return new RiskscapeFunction(){

                @Override
                public Type getReturnType() {
                    return returnType;
                }

                @Override
                public List<Type> getArgumentTypes() {
                    return argumentTypes;
                }

                @Override
                public Object call(List<Object> args) {
                    Accumulator accumulator = resolvedSetFunction.newAccumulator();
                    List values = (List)args.get(0);
                    Tuple value = new Tuple(kludgedInputType);
                    for (Object object : values) {
                        value.set(0, object);
                        accumulator.accumulate(value);
                    }
                    if (accumulator.isEmpty()) {
                        return null;
                    }
                    return accumulator.process();
                }
            };
        });
    }

    @Generated
    public AggregationFunctionAdapter(AggregationFunction aggfunction) {
        this.aggfunction = aggfunction;
    }
}

