/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.OverloadedFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RiskscapeFunction
extends UntypedFunction,
AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(RiskscapeFunction.class);
    public static final URI BUILT_IN = URI.create("internal:internal");

    public static RiskscapeFunction create(final Object source, final List<Type> argumentTypes, final Type returnType, final UntypedFunction function, AutoCloseable ... closeThese) {
        final List<AutoCloseable> closeables = Stream.of(closeThese).filter(el -> el != null).toList();
        return new RiskscapeFunction(){

            @Override
            public Object call(List<Object> args) {
                return function.call(args);
            }

            @Override
            public Type getReturnType() {
                return returnType;
            }

            @Override
            public List<Type> getArgumentTypes() {
                return argumentTypes;
            }

            public String toString() {
                String sourceString = source == null ? function.toString() : (source instanceof Class ? ((Class)source).getSimpleName() : (source instanceof RealizableFunction ? source.getClass().getSimpleName() : (source instanceof Identified ? ((Identified)source).getId() : source.toString())));
                return String.format("Function(argTypes=%s returnType=%s source=%s)", argumentTypes, returnType, sourceString);
            }

            @Override
            public void close() {
                for (AutoCloseable closeable : closeables) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        LOG.error("Exception closing {}", (Object)closeable, (Object)e);
                    }
                }
            }
        };
    }

    public List<Type> getArgumentTypes();

    public Type getReturnType();

    default public ResultOrProblems<Boolean> validate(RealizationContext context) {
        return ResultOrProblems.of(true);
    }

    default public Optional<RealizableFunction> getRealizable() {
        if (this instanceof RealizableFunction) {
            return Optional.of((RealizableFunction)((Object)this));
        }
        return Optional.empty();
    }

    default public Optional<OverloadedFunction> getOverloaded() {
        if (this instanceof OverloadedFunction) {
            return Optional.of((OverloadedFunction)((Object)this));
        }
        return Optional.empty();
    }

    default public Optional<AggregationFunction> getAggregationFunction() {
        if (this instanceof AggregationFunction) {
            return Optional.of((AggregationFunction)((Object)this));
        }
        return Optional.empty();
    }

    default public ArgumentList getArguments() {
        return ArgumentList.anonymous(this.getArgumentTypes());
    }

    default public List<Type> getTypesFromArguments() {
        return this.getArguments().getArgumentTypes();
    }

    default public void setProblemReporter(Consumer<Problem> problemReporter) {
    }

    default public IdentifiedFunction identified(String id, String description, URI source, IdentifiedFunction.Category category) {
        return new IdentifiedFunction.Wrapping(this, id, description, source, category);
    }

    default public IdentifiedFunction builtin(String id, IdentifiedFunction.Category category) {
        return this.identified(id, "", BUILT_IN, category);
    }

    default public IdentifiedFunction identified(String id) {
        return this.identified(id, "none given", Resource.UNKNOWN_URI, IdentifiedFunction.Category.UNASSIGNED);
    }

    default public <T extends RiskscapeFunction> Optional<T> isA(Class<T> type) {
        if (type.isInstance(this)) {
            return Optional.of((RiskscapeFunction)type.cast(this));
        }
        return Optional.empty();
    }

    @Override
    default public void close() {
    }
}

