/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;

public class NullSafeFunction
implements RiskscapeFunction {
    private final RiskscapeFunction target;
    private final List<Type> argumentTypes;
    private final Type returnType;
    private final boolean[] notNullableIndices;

    public static RiskscapeFunction wrap(RiskscapeFunction target) {
        if (target instanceof NullSafeFunction) {
            return target;
        }
        if (target.getArgumentTypes().stream().allMatch(t -> t.find(Nullable.class).isPresent())) {
            return target;
        }
        List<Type> argumentTypes = target.getArgumentTypes().stream().map(t -> Nullable.of(t)).collect(Collectors.toList());
        Type returnType = Nullable.of(target.getReturnType());
        return new NullSafeFunction(target, argumentTypes, returnType, NullSafeFunction.nullIndices(target));
    }

    public static RiskscapeFunction wrapIgnoringArgs(RiskscapeFunction target) {
        if (target instanceof NullSafeFunction) {
            return target;
        }
        List<Type> argumentTypes = target.getArgumentTypes().stream().map(t -> Nullable.of(t)).collect(Collectors.toList());
        Type returnType = Nullable.of(target.getReturnType());
        return new NullSafeFunction(target, argumentTypes, returnType, NullSafeFunction.nullIndices(target));
    }

    private static boolean[] nullIndices(RiskscapeFunction target) {
        boolean[] indices = new boolean[target.getArgumentTypes().size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = !target.getArgumentTypes().get(i).isNullable();
        }
        return indices;
    }

    @Override
    public Object call(List<Object> args) {
        for (int i = 0; i < this.notNullableIndices.length; ++i) {
            if (!this.notNullableIndices[i] || args.get(i) != null) continue;
            return null;
        }
        return this.target.call(args);
    }

    @Override
    public void close() {
        this.target.close();
    }

    public String toString() {
        return "NullSafe(" + String.valueOf(this.target) + ")";
    }

    @Generated
    protected NullSafeFunction(RiskscapeFunction target, List<Type> argumentTypes, Type returnType, boolean[] notNullableIndices) {
        this.target = target;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.notNullableIndices = notNullableIndices;
    }

    @Generated
    public RiskscapeFunction getTarget() {
        return this.target;
    }

    @Override
    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    @Generated
    public boolean[] getNotNullableIndices() {
        return this.notNullableIndices;
    }
}

