/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class JavaFunction
implements IdentifiedFunction {
    public static final Pattern ID_PATTERN = Pattern.compile("[\\w:_-]*");
    private final String id;
    private URI sourceURI;
    private final String description;
    private final List<Type> argumentTypes;
    private final Type returnType;
    private final Delegate delegate;
    private final IdentifiedFunction.Category category;

    public static JavaFunction asBuiltin(String id, IdentifiedFunction.Category category) {
        return new JavaFunction(id, RiskscapeFunction.BUILT_IN, id, Collections.emptyList(), Types.ANYTHING, x -> x, category);
    }

    public static JavaFunction withId(String id) {
        return new JavaFunction(id, Resource.UNKNOWN_URI, id, Collections.emptyList(), Types.ANYTHING, x -> x, IdentifiedFunction.Category.UNASSIGNED);
    }

    public JavaFunction(FunctionMetadata metadata, Delegate delegate) {
        this(metadata.getId(), metadata.getSource(), metadata.getDescription(), metadata.getArguments().getArgumentTypes(), metadata.getReturnType(), delegate, metadata.getCategory());
    }

    @Deprecated
    public static JavaFunction withIdAndSource(String id, String source) {
        return new JavaFunction(id, URI.create(source), id, Collections.emptyList(), Types.ANYTHING, x -> x, IdentifiedFunction.Category.UNASSIGNED);
    }

    public static JavaFunction withIdAndSource(String id, URI source) {
        return new JavaFunction(id, source, id, Collections.emptyList(), Types.ANYTHING, x -> x, IdentifiedFunction.Category.UNASSIGNED);
    }

    @Override
    public Object call(List<Object> args) {
        return this.delegate.apply(args);
    }

    @Override
    public ResultOrProblems<Boolean> validate(RealizationContext context) {
        List<Problem> problems = this.validateFunctionAttributes();
        if (problems.isEmpty()) {
            problems = this.delegate.validate();
        }
        if (!problems.isEmpty()) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of(true);
    }

    private List<Problem> validateFunctionAttributes() {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (!ID_PATTERN.matcher(this.id).matches()) {
            problems.add(Problem.error("ID '%s' is not allowed. ID's may only contain letters, digits, ':', '-' and '_' characters", this.id));
        }
        this.validateTypeExists(this.getReturnType(), "Return type '%s' does not exist. Refer to 'riskscape type list' for available types", p -> problems.add((Problem)p));
        for (Type argumentType : this.getArgumentTypes()) {
            this.validateTypeExists(argumentType, "Input type '%s' does not exist. Refer to 'riskscape type list' for available types", p -> problems.add((Problem)p));
        }
        return problems;
    }

    private void validateTypeExists(Type type, String messageFormat, Consumer<Problem> problems) {
        if (type instanceof IdentifiedType) {
            IdentifiedType identified = (IdentifiedType)type;
            try {
                identified.getUnderlyingType();
            }
            catch (MissingTypeException e) {
                problems.accept(Problem.error(messageFormat, identified.getId()));
            }
        }
    }

    @Override
    public ArgumentList getArguments() {
        ArgumentList fromDelegate = this.delegate.getArguments();
        if (fromDelegate != null) {
            return fromDelegate;
        }
        return IdentifiedFunction.super.getArguments();
    }

    public JavaFunction withArgumentTypes(Type ... newArgumentTypes) {
        return this.withArgumentTypes(Arrays.asList(newArgumentTypes));
    }

    public JavaFunction withArgumentTypes(List<Type> newArgumentTypes) {
        return new JavaFunction(this.id, this.sourceURI, this.description, newArgumentTypes, this.returnType, this.delegate, this.category);
    }

    public JavaFunction withReturnType(Type newReturnType) {
        return new JavaFunction(this.id, this.sourceURI, this.description, this.argumentTypes, newReturnType, this.delegate, this.category);
    }

    public JavaFunction calling(Delegate newDelegate) {
        return new JavaFunction(this.id, this.sourceURI, this.description, this.argumentTypes, this.returnType, newDelegate, this.category);
    }

    public String toString() {
        return "JavaFunction:" + this.id;
    }

    @Generated
    public JavaFunction(String id, URI sourceURI, String description, List<Type> argumentTypes, Type returnType, Delegate delegate, IdentifiedFunction.Category category) {
        this.id = id;
        this.sourceURI = sourceURI;
        this.description = description;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.delegate = delegate;
        this.category = category;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Generated
    public void setSourceURI(URI sourceURI) {
        this.sourceURI = sourceURI;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    @Generated
    public Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    @Generated
    public IdentifiedFunction.Category getCategory() {
        return this.category;
    }

    public static interface Delegate
    extends Function<List<Object>, Object> {
        @Override
        public Object apply(List<Object> var1);

        default public List<Problem> validate() {
            return Collections.emptyList();
        }

        default public ArgumentList getArguments() {
            return null;
        }
    }
}

