/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.OverloadedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;

public interface IdentifiedFunction
extends RiskscapeFunction,
Identified {
    public String getDescription();

    default public URI getSourceURI() {
        return Resource.UNKNOWN_URI;
    }

    @Deprecated
    default public String getSource() {
        return this.getSourceURI().toString();
    }

    public Category getCategory();

    default public String infoOutput() {
        return String.format("id: %s%ndescription: %s%nsource: %s%ninput types: %s%nreturn type: %s%n", this.getId(), this.getDescription(), this.getSource(), this.getArgumentTypes(), this.getReturnType());
    }

    default public Map<String, Object> toEntity() {
        return ImmutableMap.builder().put((Object)"id", (Object)this.getId()).put((Object)"description", (Object)this.getDescription()).put((Object)"argumentTypes", this.getArgumentTypes()).put((Object)"returnType", (Object)this.getReturnType()).build();
    }

    default public boolean isBuiltin() {
        return RiskscapeFunction.BUILT_IN.equals(this.getSourceURI());
    }

    public static enum Category {
        GEOMETRY_PROCESSING,
        GEOMETRY_LOGICAL,
        MATHS,
        OPERATORS,
        LOGICAL,
        STRINGS,
        LANGUAGE,
        RISK_MODELLING,
        RISK_METRICS,
        MISC,
        UNASSIGNED;

    }

    public static class Wrapping
    implements IdentifiedFunction {
        protected final RiskscapeFunction wrapped;
        private final String id;
        private final String description;
        private final URI sourceURI;
        private final Category category;

        @Override
        public Object call(List<Object> args) {
            return this.wrapped.call(args);
        }

        @Override
        public List<Type> getArgumentTypes() {
            return this.wrapped.getArgumentTypes();
        }

        @Override
        public ArgumentList getArguments() {
            return this.wrapped.getArguments();
        }

        @Override
        public Type getReturnType() {
            return this.wrapped.getReturnType();
        }

        @Override
        public Optional<RealizableFunction> getRealizable() {
            return this.wrapped.getRealizable();
        }

        @Override
        public Optional<OverloadedFunction> getOverloaded() {
            return this.wrapped.getOverloaded();
        }

        @Override
        public Optional<AggregationFunction> getAggregationFunction() {
            return this.wrapped.getAggregationFunction();
        }

        @Override
        public ResultOrProblems<Boolean> validate(RealizationContext context) {
            return this.wrapped.validate(context);
        }

        public String toString() {
            return String.format("Identified(id=%s %s)", this.id, this.wrapped);
        }

        @Override
        public void close() {
            this.wrapped.close();
        }

        @Generated
        public Wrapping(RiskscapeFunction wrapped, String id, String description, URI sourceURI, Category category) {
            this.wrapped = wrapped;
            this.id = id;
            this.description = description;
            this.sourceURI = sourceURI;
            this.category = category;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public URI getSourceURI() {
            return this.sourceURI;
        }

        @Override
        @Generated
        public Category getCategory() {
            return this.category;
        }
    }
}

