/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class FunctionArgument {
    private final String keyword;
    private final Type type;
    private final Optional<Object> defaultValue;
    private int index = -1;

    public FunctionArgument(int index, Type type) {
        this(null, type, Optional.empty());
        this.index = index;
    }

    public FunctionArgument(String keyword, Type type) {
        this(keyword, type, Optional.empty());
    }

    public void setIndex(int newIndex) {
        if (this.index != -1 && newIndex != this.index) {
            throw new IllegalStateException("index field is effectively immutable - can not be set twice");
        }
        this.index = newIndex;
    }

    public String getKeyword() {
        if (this.keyword == null) {
            return "arg" + this.index;
        }
        return this.keyword;
    }

    public boolean hasKeyword() {
        return this.keyword != null;
    }

    public boolean isAnonymous() {
        return this.keyword == null;
    }

    public String toString() {
        if (this.hasKeyword()) {
            return String.format("%s: %s", this.getKeyword(), this.type);
        }
        return this.type.toString();
    }

    public Optional<FunctionCall.Argument> getFunctionCallArgument(FunctionCall fc) {
        int givenIndex = fc.indexOfArgNamed(this.getKeyword());
        if (givenIndex >= 0) {
            return Optional.of(fc.getArguments().get(givenIndex));
        }
        List<FunctionCall.Argument> positionalArguments = fc.getPositionalArguments();
        if (this.index < positionalArguments.size()) {
            return Optional.of(positionalArguments.get(this.index));
        }
        return Optional.empty();
    }

    public <T> ResultOrProblems<T> evaluateConstant(RealizationContext context, FunctionCall functionCall, Class<T> requiredJavaType) {
        return this.mapFunctionCall(functionCall, arg -> arg.evaluateConstant(context, requiredJavaType, this.type));
    }

    public <T> ResultOrProblems<T> mapFunctionCall(FunctionCall fc, Function<FunctionCall.Argument, ResultOrProblems<T>> mapper) {
        return this.getFunctionCallArgument(fc).map(arg -> ((ResultOrProblems)mapper.apply((FunctionCall.Argument)arg)).composeProblems(Problems.foundWith((Object)this, new Problem[0]))).orElse(ResultOrProblems.failed(ArgsProblems.get().required(this.getKeyword())));
    }

    @Generated
    public FunctionArgument(String keyword, Type type, Optional<Object> defaultValue) {
        this.keyword = keyword;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Optional<Object> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionArgument)) {
            return false;
        }
        FunctionArgument other = (FunctionArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Optional<Object> this$defaultValue = this.getDefaultValue();
        Optional<Object> other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !((Object)this$defaultValue).equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Optional<Object> $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : ((Object)$defaultValue).hashCode());
        return result;
    }
}

