/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import lombok.Generated;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.rl.TokenTypes;

public class BinaryPredicateFunction<T, U>
implements RiskscapeFunction {
    private TokenTypes operation;
    private final BiPredicate<T, U> predicate;
    private final Class<T> lhsJavaType;
    private final Class<U> rhsJavaType;
    private final List<Type> argumentTypes;
    private final Type lhsType;
    private final Type rhsType;
    private final Type returnType = Types.BOOLEAN;

    public static BinaryPredicateFunction<Object, Object> untyped(TokenTypes operation, Type lhs, Type rhs, BiPredicate<Object, Object> predicate) {
        return new BinaryPredicateFunction<Object, Object>(operation, Object.class, lhs, Object.class, rhs, predicate);
    }

    public static <T> BinaryPredicateFunction<T, T> uniform(TokenTypes operation, Type type, Class<T> javaType, BiPredicate<T, T> predicate) {
        return new BinaryPredicateFunction<T, T>(operation, javaType, type, javaType, type, predicate);
    }

    public BinaryPredicateFunction(TokenTypes operation, Class<T> lhsJavaType, Type lhsType, Class<U> rhsJavaType, Type rhsType, BiPredicate<T, U> predicate) {
        if (!lhsJavaType.isAssignableFrom(lhsType.internalType())) {
            throw new IllegalArgumentException("Can not construct a predicate function from mismatched java and riskscape types");
        }
        if (!rhsJavaType.isAssignableFrom(rhsType.internalType())) {
            throw new IllegalArgumentException("Can not construct a predicate function from mismatched java and riskscape types");
        }
        this.operation = operation;
        this.predicate = predicate;
        this.lhsJavaType = lhsJavaType;
        this.lhsType = lhsType;
        this.rhsJavaType = rhsJavaType;
        this.rhsType = rhsType;
        this.argumentTypes = Arrays.asList(lhsType, rhsType);
    }

    @Override
    public Object call(List<Object> args) {
        return this.predicate.test(this.lhsJavaType.cast(args.get(0)), this.rhsJavaType.cast(args.get(1)));
    }

    public String toString() {
        return String.format("BinaryPredicate[operation=%s, types=%s]", this.operation, this.argumentTypes);
    }

    @Generated
    public TokenTypes getOperation() {
        return this.operation;
    }

    @Generated
    public BiPredicate<T, U> getPredicate() {
        return this.predicate;
    }

    @Generated
    public Class<T> getLhsJavaType() {
        return this.lhsJavaType;
    }

    @Generated
    public Class<U> getRhsJavaType() {
        return this.rhsJavaType;
    }

    @Override
    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getLhsType() {
        return this.lhsType;
    }

    @Generated
    public Type getRhsType() {
        return this.rhsType;
    }

    @Override
    @Generated
    public Type getReturnType() {
        return this.returnType;
    }
}

