/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.Arrays;
import java.util.List;
import java.util.function.BinaryOperator;
import lombok.Generated;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.rl.TokenTypes;

public class BinaryOperatorFunction<T>
implements RiskscapeFunction {
    private TokenTypes operation;
    private final BinaryOperator<T> operator;
    private final Class<T> javaType;
    private final Type returnType;
    private final List<Type> argumentTypes;

    public BinaryOperatorFunction(TokenTypes operation, BinaryOperator<T> operator, Class<T> javaType) {
        this(operation, operator, javaType, Types.fromJavaType(javaType));
    }

    public BinaryOperatorFunction(TokenTypes operation, BinaryOperator<T> operator, Class<T> javaType, Type riskscapeType) {
        if (!riskscapeType.internalType().equals(javaType)) {
            throw new IllegalArgumentException("Can not construct an operator function from mismatched java and riskscape types");
        }
        this.operation = operation;
        this.operator = operator;
        this.javaType = javaType;
        this.returnType = riskscapeType;
        this.argumentTypes = Arrays.asList(riskscapeType, riskscapeType);
    }

    @Override
    public Object call(List<Object> args) {
        return this.operator.apply(this.javaType.cast(args.get(0)), this.javaType.cast(args.get(1)));
    }

    public String toString() {
        return String.format("BinaryOperator[operation=%s, type=%s]", this.operation, this.returnType);
    }

    @Generated
    public TokenTypes getOperation() {
        return this.operation;
    }

    @Generated
    public BinaryOperator<T> getOperator() {
        return this.operator;
    }

    @Generated
    public Class<T> getJavaType() {
        return this.javaType;
    }

    @Override
    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

