/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class BinaryFunction<T, U>
implements RiskscapeFunction {
    private Type returnType;
    private BiFunction<T, U, Object> function;
    private final ArgumentList arguments;
    private final List<Type> argumentTypes;

    public BinaryFunction(FunctionArgument lhs, FunctionArgument rhs, Type returnType, BiFunction<T, U, Object> function) {
        this.returnType = returnType;
        this.function = function;
        this.arguments = ArgumentList.fromArray(lhs, rhs);
        this.argumentTypes = this.arguments.getArgumentTypes();
    }

    public BinaryFunction(Type lhs, Type rhs, Type returnType, BiFunction<T, U, Object> function) {
        this.returnType = returnType;
        this.function = function;
        this.arguments = ArgumentList.fromArray(new FunctionArgument("lhs", lhs), new FunctionArgument("rhs", rhs));
        this.argumentTypes = this.arguments.getArgumentTypes();
    }

    public BinaryFunction(Class<T> lhsJavaType, Class<U> rhsJavaType, Type returnType, BiFunction<T, U, Object> function) {
        this(Types.fromJavaType(lhsJavaType), Types.fromJavaType(rhsJavaType), returnType, function);
    }

    @Override
    public Object call(List<Object> args) {
        Object lhsArg = args.get(0);
        Object rhsArg = args.get(1);
        return this.function.apply(lhsArg, rhsArg);
    }

    @Override
    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Override
    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

