/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ArgumentList
extends AbstractList<FunctionArgument> {
    private final List<FunctionArgument> arguments;
    private List<String> keywords;

    public static ArgumentList fromArray(FunctionArgument ... functionArguments) {
        return new ArgumentList(Arrays.asList(functionArguments));
    }

    public static ArgumentList fromStruct(Struct struct) {
        return new ArgumentList(struct.getMembers().stream().map(sm -> new FunctionArgument(sm.getKey(), sm.getType())).collect(Collectors.toList()));
    }

    public static ArgumentList anonymous(List<Type> argTypes) {
        ArrayList<FunctionArgument> args = new ArrayList<FunctionArgument>(argTypes.size());
        int index = 0;
        for (Type type : argTypes) {
            args.add(new FunctionArgument(index, type));
            ++index;
        }
        return new ArgumentList(args);
    }

    public ArgumentList(List<FunctionArgument> asList) {
        this.arguments = asList;
        for (int i = 0; i < asList.size(); ++i) {
            this.arguments.get(i).setIndex(i);
        }
    }

    public static ArgumentList create() {
        return new ArgumentList(List.of());
    }

    public static ArgumentList create(String kw0, Type t0) {
        return new ArgumentList(Arrays.asList(new FunctionArgument(kw0, t0)));
    }

    public static ArgumentList create(String kw0, Type t0, String kw1, Type t1) {
        return new ArgumentList(Arrays.asList(new FunctionArgument(kw0, t0), new FunctionArgument(kw1, t1)));
    }

    public static ArgumentList create(String kw0, Type t0, String kw1, Type t1, String kw2, Type t2) {
        return new ArgumentList(Arrays.asList(new FunctionArgument(kw0, t0), new FunctionArgument(kw1, t1), new FunctionArgument(kw2, t2)));
    }

    public static ArgumentList create(String kw0, Type t0, String kw1, Type t1, String kw2, Type t2, String kw3, Type t3) {
        return new ArgumentList(Arrays.asList(new FunctionArgument(kw0, t0), new FunctionArgument(kw1, t1), new FunctionArgument(kw2, t2), new FunctionArgument(kw3, t3)));
    }

    @Override
    public FunctionArgument get(int index) {
        return this.arguments.get(index);
    }

    @Override
    public int size() {
        return this.arguments.size();
    }

    public Range<Integer> getArity() {
        return Range.closed((Comparable)Integer.valueOf(this.getMinimumSize()), (Comparable)Integer.valueOf(this.size()));
    }

    private int getMinimumSize() {
        int argNum;
        List<Type> argTypes = this.getArgumentTypes();
        for (argNum = argTypes.size(); argNum > 0 && argTypes.get(argNum - 1).isNullable(); --argNum) {
        }
        return argNum;
    }

    public FunctionArgument get(String keyword) {
        for (FunctionArgument functionArgument : this.arguments) {
            if (!functionArgument.getKeyword().equals(keyword)) continue;
            return functionArgument;
        }
        new IllegalArgumentException("no argument named " + keyword + " is declared");
        return null;
    }

    public boolean hasArgument(String keyword) {
        return this.getKeywords().contains(keyword);
    }

    public List<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = this.arguments.stream().map(FunctionArgument::getKeyword).collect(Collectors.toList());
        }
        return this.keywords;
    }

    public List<Type> getArgumentTypes() {
        return this.stream().map(FunctionArgument::getType).collect(Collectors.toList());
    }

    public Optional<FunctionCall.Argument> getArgument(FunctionCall fc, String keywordName) {
        return this.get(keywordName).getFunctionCallArgument(fc);
    }

    public ResultOrProblems<FunctionCall.Argument> getRequiredArgument(FunctionCall fc, String keyword) {
        return this.getArgument(fc, keyword).map(a -> ResultOrProblems.of(a)).orElse(ResultOrProblems.failed(ArgsProblems.get().required(keyword)));
    }

    public <T extends Type> ResultOrProblems<T> getRequiredAs(List<Type> givenTypes, int argIndex, Class<T> requiredType) {
        FunctionArgument expected = this.get(argIndex);
        if (givenTypes.size() <= argIndex) {
            return ResultOrProblems.failed(GeneralProblems.get().required(expected));
        }
        Type givenType = givenTypes.get(argIndex);
        if (!givenType.findAllowNull(requiredType).isPresent()) {
            return ResultOrProblems.failed(ArgsProblems.mismatch(expected, givenType));
        }
        return ResultOrProblems.of((Type)givenType.findAllowNull(requiredType).get());
    }

    @Deprecated
    public <T> ResultOrProblems<T> evaluateConstant(RealizationContext context, FunctionCall functionCall, String keyword, Class<T> requiredJavaType, Type requiredType) {
        return this.get(keyword).evaluateConstant(context, functionCall, requiredJavaType);
    }

    public boolean isCompatible(RealizationContext context, List<Type> givenTypes) {
        return this.getArgumentTypes().equals(givenTypes) || this.areArgsAssignable(context.getProject().getTypeSet(), givenTypes);
    }

    private boolean areArgsAssignable(TypeSet typeSet, List<Type> givenTypes) {
        return this.getArity().contains((Comparable)Integer.valueOf(givenTypes.size())) && Streams.zip(givenTypes.stream(), this.getArgumentTypes().stream(), Pair::of).allMatch(pair -> typeSet.isAssignable((Type)pair.getLeft(), (Type)pair.getRight()));
    }

    public ArgumentList withExtraArgument(String keyword, Type type) {
        return this.withExtraArgument(new FunctionArgument(keyword, type));
    }

    public ArgumentList withExtraArgument(FunctionArgument ... extraArgs) {
        ArrayList newArguments = Lists.newArrayList((Iterable)this);
        for (FunctionArgument extraArg : extraArgs) {
            newArguments.add(extraArg);
        }
        return new ArgumentList(newArguments);
    }

    public List<Problem> getProblems(RealizationContext context, List<Type> givenArgs) {
        return this.getProblems(context, givenArgs, (expected, given) -> Arrays.asList(ArgsProblems.mismatch(expected, given)));
    }

    public List<Problem> getProblems(RealizationContext context, List<Type> givenArgs, BiFunction<FunctionArgument, Type, List<Problem>> describeMismatch) {
        if (!this.getArity().contains((Comparable)Integer.valueOf(givenArgs.size()))) {
            return Arrays.asList(ArgsProblems.get().wrongNumber(this.getArity(), givenArgs.size()));
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        TypeSet typeset = context.getProject().getTypeSet();
        for (int i = 0; i < givenArgs.size(); ++i) {
            FunctionArgument expectedArg = this.get(i);
            Type givenType = givenArgs.get(i);
            if (typeset.isAssignable(givenType, expectedArg.getType()) || typeset.findEquivalenceCoercer(givenType, expectedArg.getType()).isPresent()) continue;
            problems.addAll((Collection<Problem>)describeMismatch.apply(expectedArg, givenType));
        }
        if (problems.isEmpty() && !this.isCompatible(context, givenArgs)) {
            return Arrays.asList(ArgsProblems.get().realizableDidNotMatch(RiskscapeFunction.class, givenArgs));
        }
        return problems;
    }
}

