/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.SelfDescribingScalarData;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public interface ResolvedBookmark {
    public static ResolvedBookmark withId(String bookmarkId, Object object) {
        return ResolvedBookmark.withId(bookmarkId, object, Collections.emptyList(), Collections.emptyList());
    }

    public static ResolvedBookmark withId(@NonNull String bookmarkId, @NonNull Object object, @NonNull List<Problem> dataProblems, @NonNull List<Problem> validationProblems) {
        if (bookmarkId == null) {
            throw new NullPointerException("bookmarkId is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (dataProblems == null) {
            throw new NullPointerException("dataProblems is marked non-null but is null");
        }
        if (validationProblems == null) {
            throw new NullPointerException("validationProblems is marked non-null but is null");
        }
        URI pseudoUri = URI.create("test:" + bookmarkId);
        Bookmark bookmark = new Bookmark(bookmarkId, null, null, pseudoUri, Collections.emptyMap());
        return ResolvedBookmark.stub(bookmark, object, dataProblems, validationProblems);
    }

    public static ResolvedBookmark stub(@NonNull Bookmark bookmark, @NonNull Object object) {
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return ResolvedBookmark.stub(bookmark, object, List.of(), List.of());
    }

    public static ResolvedBookmark stub(final @NonNull Bookmark bookmark, final @NonNull Object object, final @NonNull List<Problem> dataProblems, final @NonNull List<Problem> validationProblems) {
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (dataProblems == null) {
            throw new NullPointerException("dataProblems is marked non-null but is null");
        }
        if (validationProblems == null) {
            throw new NullPointerException("validationProblems is marked non-null but is null");
        }
        final Type scalarType = SelfDescribingScalarData.getScalarDataType(object).get();
        return new ResolvedBookmark(){

            @Override
            public <T> Optional<ResultOrProblems<T>> getIfType(Class<T> requiredType) {
                if (requiredType.isInstance(object)) {
                    return Optional.of(ResultOrProblems.of(requiredType.cast(object), dataProblems));
                }
                return Optional.empty();
            }

            @Override
            public Class<?> getDataType() {
                return object.getClass();
            }

            @Override
            public Bookmark getBookmark() {
                return bookmark;
            }

            @Override
            public Type getScalarType() {
                return scalarType;
            }

            @Override
            public List<Problem> validate() {
                return validationProblems;
            }
        };
    }

    default public String getId() {
        return this.getBookmark().getId();
    }

    public Bookmark getBookmark();

    default public <T> ResultOrProblems<T> getData(Class<T> requiredType) {
        return this.getIfType(requiredType).orElse(ResultOrProblems.failed(Problems.get(TypeProblems.class).mismatch((Object)this.getBookmark(), requiredType, this.getDataType())));
    }

    public <T> Optional<ResultOrProblems<T>> getIfType(Class<T> var1);

    public Class<?> getDataType();

    default public boolean isType(Class<?> requiredType) {
        return this.getIfType(requiredType).isPresent();
    }

    public List<Problem> validate();

    public Type getScalarType();

    default public boolean hasValidationErrors() {
        return Problem.hasErrors(this.validate());
    }
}

