/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.util.ListUtils;

public class Bookmark
implements Identified {
    private final String id;
    private final String description;
    private final String format;
    private final URI location;
    private final Map<String, List<?>> unparsed = Maps.newHashMap();
    private final boolean fromURI;

    public static Bookmark fromURI(URI uri) {
        return Bookmark.fromURI(uri, uri.toString());
    }

    public static Bookmark fromURI(URI uri, String id) {
        return new Bookmark(id, uri.toString(), null, uri, true).addUnparsed(Bookmark.parseQueryString(uri.getQuery()));
    }

    static Map<String, List<?>> parseQueryString(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return ImmutableMap.of();
        }
        return Arrays.asList(query.split("&")).stream().map(kv -> kv.split("=", 2)).filter(kv -> ((String[])kv).length == 2).collect(Collectors.toMap(kv -> kv[0], kv -> Arrays.asList(Bookmark.decode(kv[1])), ListUtils::concat));
    }

    private static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Utf-8 is missing, wah", e);
        }
    }

    public Bookmark(String id, String description, String format, URI location, Map<String, List<String>> unparsed) {
        this(id, description, format, location, false);
        this.unparsed.putAll(unparsed);
    }

    public Bookmark addUnparsed(Map<String, List<?>> toAdd) {
        this.unparsed.putAll(toAdd);
        return this;
    }

    public Map<String, List<?>> getParamMap() {
        HashMap map = new HashMap();
        map.putAll(this.unparsed);
        map.put("location", Arrays.asList(this.location));
        if (!Strings.isNullOrEmpty((String)this.format)) {
            map.put("format", Arrays.asList(this.format));
        }
        if (!Strings.isNullOrEmpty((String)this.description)) {
            map.put("description", Arrays.asList(this.description));
        }
        return Map.copyOf(map);
    }

    public String toString() {
        return String.format("Bookmark[id: %s, location: %s]", this.id, this.location);
    }

    public Bookmark clone() {
        return new Bookmark(this.id, this.description, this.format, this.location, this.fromURI).addUnparsed(this.unparsed);
    }

    public Bookmark withFormat(String newFormat) {
        return new Bookmark(this.id, this.description, newFormat, this.location, this.fromURI).addUnparsed(this.unparsed);
    }

    public Bookmark withLocation(URI newLocation) {
        return new Bookmark(this.id, this.description, this.format, newLocation, this.fromURI).addUnparsed(this.unparsed);
    }

    @Generated
    public static BookmarkBuilder builder() {
        return new BookmarkBuilder();
    }

    @Generated
    public Bookmark(String id, String description, String format, URI location, boolean fromURI) {
        this.id = id;
        this.description = description;
        this.format = format;
        this.location = location;
        this.fromURI = fromURI;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bookmark)) {
            return false;
        }
        Bookmark other = (Bookmark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFromURI() != other.isFromURI()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        URI this$location = this.getLocation();
        URI other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Map<String, List<?>> this$unparsed = this.getUnparsed();
        Map<String, List<?>> other$unparsed = other.getUnparsed();
        return !(this$unparsed == null ? other$unparsed != null : !((Object)this$unparsed).equals(other$unparsed));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bookmark;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFromURI() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        URI $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Map<String, List<?>> $unparsed = this.getUnparsed();
        result = result * 59 + ($unparsed == null ? 43 : ((Object)$unparsed).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public URI getLocation() {
        return this.location;
    }

    @Generated
    public Map<String, List<?>> getUnparsed() {
        return this.unparsed;
    }

    @Generated
    public boolean isFromURI() {
        return this.fromURI;
    }

    @Generated
    public static class BookmarkBuilder {
        @Generated
        private String id;
        @Generated
        private String description;
        @Generated
        private String format;
        @Generated
        private URI location;
        @Generated
        private boolean fromURI;

        @Generated
        BookmarkBuilder() {
        }

        @Generated
        public BookmarkBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public BookmarkBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public BookmarkBuilder format(String format) {
            this.format = format;
            return this;
        }

        @Generated
        public BookmarkBuilder location(URI location) {
            this.location = location;
            return this;
        }

        @Generated
        public BookmarkBuilder fromURI(boolean fromURI) {
            this.fromURI = fromURI;
            return this;
        }

        @Generated
        public Bookmark build() {
            return new Bookmark(this.id, this.description, this.format, this.location, this.fromURI);
        }

        @Generated
        public String toString() {
            return "Bookmark.BookmarkBuilder(id=" + this.id + ", description=" + this.description + ", format=" + this.format + ", location=" + String.valueOf(this.location) + ", fromURI=" + this.fromURI + ")";
        }
    }
}

