/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.coverage;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.data.SelfDescribingScalarData;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public interface TypedCoverage
extends SelfDescribingScalarData {
    public static final CoordinateReferenceSystem DEFAULT_CRS = CartesianAuthorityFactory.GENERIC_2D;

    public static TypedCoverage empty(Type type) {
        return new Empty(type);
    }

    public Type getType();

    public Object evaluate(Point var1);

    default public Optional<Function<Geometry, List<Pair<Geometry, Object>>>> getEvaluateIntersectionOp() {
        return Optional.empty();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    default public Optional<ReferencedEnvelope> getEnvelope() {
        return Optional.empty();
    }

    @Override
    default public Type getScalarDataType() {
        return new CoverageType(this.getType());
    }

    default public Optional<Relation> asRelation() {
        return Optional.empty();
    }

    public static class Empty
    implements TypedCoverage {
        private final Type type;

        @Override
        public Object evaluate(Point point) {
            return null;
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return DEFAULT_CRS;
        }

        @Generated
        public Empty(Type type) {
            this.type = type;
        }

        @Override
        @Generated
        public Type getType() {
            return this.type;
        }
    }
}

