/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.util.List;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.cli.ExitCode;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class ExitException
extends RiskscapeException {
    public static final Problem NO_PROBLEM = new Problem(Problem.Severity.INFO, "");
    private static final long serialVersionUID = 921444503735663014L;
    private static final int DEFAULT_ERROR_EXIT_CODE = 1;
    private final int exitCode;

    public static void quit() {
        throw new ExitException(0, NO_PROBLEM);
    }

    public ExitException(int exitCode, String message, Object ... formatArgs) {
        this(exitCode, null, message, formatArgs);
    }

    public ExitException(int exitCode, String message, List<Problem> problems) {
        super(Problem.composite(problems, "%s", message));
        this.exitCode = exitCode;
    }

    public ExitException(int exitCode, Problems problem) {
        super(problem);
        this.exitCode = exitCode;
    }

    public ExitException(Problems problem) {
        this(problem, null);
    }

    public ExitException(Problems problem, Throwable cause) {
        super(problem, cause);
        this.exitCode = 1;
    }

    public ExitException(int exitCode, Throwable cause, String message, Object ... formatArgs) {
        super(String.format(message, formatArgs), cause);
        this.exitCode = exitCode;
    }

    public ExitCode toExitCode(Messages messages) {
        if (this.getProblem() == NO_PROBLEM) {
            return new ExitCode(this.exitCode);
        }
        return new ExitCode(this.exitCode, messages.renderProblem(this).toString());
    }
}

