/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.picocli.CommandLine;

public class ExitCode {
    private final int code;
    private final Optional<String> message;

    public ExitCode(int code, String message) {
        this.code = code;
        this.message = Optional.of(message);
    }

    public ExitCode(int code) {
        this.code = code;
        this.message = Optional.empty();
    }

    public void action(PrintStream out, Runnable beforeExit, Consumer<Integer> exithook) {
        this.message.ifPresent(str -> {
            if (this.code != 0) {
                out.println(CommandLine.Help.Ansi.AUTO.apply((String)str, Arrays.asList(CommandLine.Help.Ansi.Style.fg_red)));
            } else {
                out.println((String)str);
            }
        });
        if (beforeExit != null) {
            beforeExit.run();
        }
        exithook.accept(this.code);
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public Optional<String> getMessage() {
        return this.message;
    }
}

