/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.problem.Problem;

public class ParameterTemplate {
    public static final ParameterTemplate EMPTY = new ParameterTemplate(Optional.empty(), Optional.empty(), Collections.emptySet(), Collections.emptyList(), Optional.empty());
    private final Optional<String> label;
    private final Optional<String> description;
    private final Set<ParameterProperty> properties;
    private final List<Choice> choices;
    private final Optional<String> defaultValue;

    public ParameterTemplate(Optional<String> label, Optional<String> description, Set<ParameterProperty> properties, List<Choice> choices) {
        this(label, description, properties, choices, Optional.empty());
    }

    public boolean hasProperty(ParameterProperty property) {
        return this.getProperty(property).isPresent();
    }

    public <T extends ParameterProperty> Optional<T> getProperty(T property) {
        return this.properties.stream().filter(p -> p.equals(property)).map(p -> p).findFirst();
    }

    public ParameterTemplate withLabel(String newLabel) {
        return new ParameterTemplate(Optional.of(newLabel), this.description, this.properties, this.choices, this.defaultValue);
    }

    public ParameterTemplate withProperties(Set<ParameterProperty> newProperties) {
        return new ParameterTemplate(this.label, this.description, newProperties, this.choices, this.defaultValue);
    }

    public ParameterTemplate withDefaultValue(String newDefault) {
        return new ParameterTemplate(this.label, this.description, this.properties, this.choices, Optional.of(newDefault));
    }

    public List<Problem> validate(BindingContext context, Object bound) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (ParameterProperty property : this.getProperties()) {
            problems.addAll(property.validate(context, bound));
        }
        return problems;
    }

    public Set<ParameterProperty> getProperties() {
        LinkedHashSet<ParameterProperty> allProperties = new LinkedHashSet<ParameterProperty>();
        for (ParameterProperty property : this.properties) {
            allProperties.add(property);
            allProperties.addAll(property.getImplied());
        }
        return allProperties;
    }

    @Generated
    public ParameterTemplate(Optional<String> label, Optional<String> description, Set<ParameterProperty> properties, List<Choice> choices, Optional<String> defaultValue) {
        this.label = label;
        this.description = description;
        this.properties = properties;
        this.choices = choices;
        this.defaultValue = defaultValue;
    }

    @Generated
    public Optional<String> getLabel() {
        return this.label;
    }

    @Generated
    public Optional<String> getDescription() {
        return this.description;
    }

    @Generated
    public List<Choice> getChoices() {
        return this.choices;
    }

    @Generated
    public Optional<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterTemplate)) {
            return false;
        }
        ParameterTemplate other = (ParameterTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$label = this.getLabel();
        Optional<String> other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        Set<ParameterProperty> this$properties = this.getProperties();
        Set<ParameterProperty> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<Choice> this$choices = this.getChoices();
        List<Choice> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        Optional<String> this$defaultValue = this.getDefaultValue();
        Optional<String> other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !((Object)this$defaultValue).equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParameterTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        Set<ParameterProperty> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<Choice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        Optional<String> $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : ((Object)$defaultValue).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParameterTemplate(label=" + String.valueOf(this.getLabel()) + ", description=" + String.valueOf(this.getDescription()) + ", properties=" + String.valueOf(this.getProperties()) + ", choices=" + String.valueOf(this.getChoices()) + ", defaultValue=" + String.valueOf(this.getDefaultValue()) + ")";
    }

    public static class Choice {
        private final Object value;
        private final Optional<String> label;

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public Optional<String> getLabel() {
            return this.label;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Choice)) {
                return false;
            }
            Choice other = (Choice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Optional<String> this$label = this.getLabel();
            Optional<String> other$label = other.getLabel();
            return !(this$label == null ? other$label != null : !((Object)this$label).equals(other$label));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Choice;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Optional<String> $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ParameterTemplate.Choice(value=" + String.valueOf(this.getValue()) + ", label=" + String.valueOf(this.getLabel()) + ")";
        }

        @Generated
        public Choice(Object value, Optional<String> label) {
            this.value = value;
            this.label = label;
        }
    }
}

