/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class ParameterSet {
    public static final ParameterSet EMPTY = new ParameterSet(Collections.emptyList());
    private final LinkedHashSet<Parameter> declared;

    public static Map<String, List<?>> normaliseParameterMap(Map<String, ?> optionsMap) {
        return Maps.transformValues(optionsMap, v -> v instanceof List ? (List<Object>)v : Arrays.asList(v));
    }

    public static ParameterSet from(Parameter ... declaredParameters) {
        return new ParameterSet(Arrays.asList(declaredParameters));
    }

    public static ParameterSet fromList(Collection<Parameter> declaredParameters) {
        return new ParameterSet(declaredParameters);
    }

    public ParameterSet(Collection<Parameter> from) {
        this.declared = new LinkedHashSet(from.size());
        for (Parameter toAdd : from) {
            Parameter existing = this.declared.stream().filter(p -> p.getName().equals(toAdd.getName())).findFirst().orElse(null);
            if (existing != null) {
                throw new IllegalArgumentException("Can not add two parameters with the same name - " + String.valueOf(Arrays.asList(toAdd, existing)));
            }
            this.declared.add(toAdd);
        }
    }

    public BoundParameters bindConfig(BindingContext context, Map<ConfigString, List<ConfigString>> unboundConfig) {
        HashMap unbound = new HashMap();
        Set<Map.Entry<ConfigString, List<ConfigString>>> entrySet = unboundConfig.entrySet();
        for (Map.Entry<ConfigString, List<ConfigString>> entry : entrySet) {
            unbound.put(entry.getKey().toString(), entry.getValue());
        }
        return this.bind(context, unbound);
    }

    public BoundParameters bind(BindingContext context, Map<String, List<?>> unbound) {
        ArrayList<Problem> collectedErrors = new ArrayList<Problem>();
        HashMap bound = new HashMap();
        for (Parameter param : this.declared) {
            ArrayList convertedList;
            List valueList = unbound.getOrDefault(param.getName(), Collections.emptyList());
            int numValues = valueList.size();
            if (valueList.isEmpty() && param.getDefaultFunction().isPresent()) {
                try {
                    convertedList = param.getDefaultValues(context);
                }
                catch (ParameterBindingException e) {
                    collectedErrors.add(e.getProblem());
                    convertedList = Collections.emptyList();
                }
            } else {
                ArrayList boundParameterList = Lists.newArrayListWithExpectedSize((int)numValues);
                if (numValues < param.getMinRequired() || numValues > param.getMaxRequired()) {
                    if (numValues == 0) {
                        collectedErrors.add(GeneralProblems.get().required(param));
                    } else {
                        collectedErrors.add(ParamProblems.get().wrongNumberGiven(param.getName(), param.getArity(), numValues));
                    }
                }
                for (Object value : valueList) {
                    Object converted;
                    if (param.getType().isInstance(value)) {
                        boundParameterList.add(value);
                        continue;
                    }
                    ResultOrProblems<?> bindResult = context.bind(value, param);
                    if (bindResult.hasErrors()) {
                        collectedErrors.addAll(bindResult.getProblems());
                        continue;
                    }
                    if (!bindResult.isPresent() || (converted = bindResult.drainWarnings(p -> collectedErrors.add((Problem)p)).get()) == null) continue;
                    boundParameterList.add(converted);
                }
                convertedList = boundParameterList;
            }
            bound.put(param.getName(), convertedList);
        }
        return new BoundParameters(this, context, bound, unbound, collectedErrors);
    }

    public boolean contains(String parameterName) {
        for (Parameter parameter : this.declared) {
            if (!parameter.getName().equals(parameterName)) continue;
            return true;
        }
        return false;
    }

    public Parameter get(String parameterName) {
        for (Parameter parameter : this.declared) {
            if (!parameter.getName().equals(parameterName)) continue;
            return parameter;
        }
        throw new IllegalArgumentException("No such parameter - " + parameterName);
    }

    public String toString() {
        return String.format("ParameterSet(%s)", this.declared.stream().map(Parameter::getName).collect(Collectors.joining(", ", "[", "]")));
    }

    public int size() {
        return this.declared.size();
    }

    public List<Parameter> toList() {
        return new ArrayList<Parameter>(this.declared);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterSet)) {
            return false;
        }
        ParameterSet other = (ParameterSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LinkedHashSet<Parameter> this$declared = this.getDeclared();
        LinkedHashSet<Parameter> other$declared = other.getDeclared();
        return !(this$declared == null ? other$declared != null : !((Object)this$declared).equals(other$declared));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParameterSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LinkedHashSet<Parameter> $declared = this.getDeclared();
        result = result * 59 + ($declared == null ? 43 : ((Object)$declared).hashCode());
        return result;
    }

    @Generated
    public LinkedHashSet<Parameter> getDeclared() {
        return this.declared;
    }
}

