/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.io.File;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.problem.ResultOrProblems;

public interface ParameterBinder
extends Identified {
    public static boolean validateExistingFileOrUri(Parameter param, String value) {
        try {
            File file = Paths.get(value, new String[0]).toFile();
            if (file.exists() && !file.isDirectory()) {
                return true;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        try {
            if (value.contains("://")) {
                URI.create(value);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public static <T extends Identified> T wrapFailedObject(Parameter parameter, String id, IdentifiedCollection<T> collection) {
        try {
            return collection.get(id);
        }
        catch (FailedObjectException ex) {
            throw new ParameterBindingException(parameter, ex.getProblem());
        }
    }

    public static <T extends Identified> T wrapLookup(Parameter parameter, String id, BindingContext context, Class<T> identifedClass) {
        IdentifiedCollection<T> collection = context.getProject().getCollectionByClass(identifedClass);
        try {
            return collection.get(id, context.getProject().getProblemSink());
        }
        catch (FailedObjectException | NoSuchObjectException ex) {
            throw new ParameterBindingException(parameter, ex.getProblem());
        }
    }

    public boolean canBind(Class<?> var1, Class<?> var2);

    @Deprecated
    public Object bind(BindingContext var1, Parameter var2, String var3) throws ParameterBindingException;

    public <T> ResultOrProblems<T> bindValue(BindingContext var1, Object var2, Class<T> var3);
}

