/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.problem.Problem;

public class Parameter {
    public static final String NO_DEFAULT = "No default supplied";
    public static final BiFunction<BindingContext, Object, List<Problem>> NO_VALIDATION = (c, v) -> Collections.emptyList();
    @NonNull
    private final String name;
    @NonNull
    private final Class<?> type;
    @NonNull
    private final Optional<BiFunction<BindingContext, Parameter, List<?>>> defaultFunction;
    private final int minRequired;
    private final int maxRequired;
    @NonNull
    private final BiFunction<BindingContext, Object, List<Problem>> validation;

    public static <T> Parameter required(String name, Class<T> type) {
        return Parameter.range(name, type, 1, 1);
    }

    public static <T> Parameter required(String name, Class<T> type, T constantDefault) {
        return Parameter.required(name, type).withNewDefaults((a, b) -> Collections.singletonList(constantDefault));
    }

    public static <T> Parameter range(String name, Class<T> type, int min, int max) {
        return new Parameter(name, type, Optional.empty(), min, max);
    }

    public static Parameter optional(String name, Class<?> type) {
        return Parameter.range(name, type, 0, 1);
    }

    public static Parameter optional(String name, Class<?> type, int max) {
        return Parameter.range(name, type, 0, max);
    }

    public Parameter(@NonNull String name, @NonNull Class<?> type, @NonNull Optional<BiFunction<BindingContext, Parameter, List<?>>> function, int min, int max) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.name = name;
        this.type = type;
        this.defaultFunction = function;
        this.minRequired = min;
        this.maxRequired = max;
        this.validation = NO_VALIDATION;
        if (min < 0) {
            throw new IllegalArgumentException("minRequired can not be less than zero");
        }
        if (max < 1) {
            throw new IllegalArgumentException("maxRequired must be greater than zero");
        }
        if (min > max) {
            throw new IllegalArgumentException("minRequired can not be greater than maxRequired");
        }
    }

    private Parameter(MutableFields fields) {
        this.name = fields.name;
        this.type = fields.type;
        this.defaultFunction = fields.defaultFunction;
        this.minRequired = fields.minRequired;
        this.maxRequired = fields.maxRequired;
        this.validation = fields.validation;
    }

    protected Parameter clone(Consumer<MutableFields> mutator) {
        MutableFields fields = new MutableFields(this);
        mutator.accept(fields);
        return new Parameter(fields);
    }

    public List<?> getDefaultValues(BindingContext modelContext) throws ParameterBindingException {
        if (this.defaultFunction.isPresent()) {
            return this.defaultFunction.get().apply(modelContext, this);
        }
        return Collections.emptyList();
    }

    public boolean isOptional() {
        return this.minRequired == 0;
    }

    public boolean isMany() {
        return this.maxRequired > 1;
    }

    public boolean hasDefaultValue() {
        return this.defaultFunction.isPresent();
    }

    public Parameter withNewDefaults(BiFunction<BindingContext, Parameter, List<?>> newDefaultFunction) {
        return this.clone(fields -> {
            fields.defaultFunction = Optional.of(newDefaultFunction);
        });
    }

    public Parameter withNewName(String newName) {
        return this.clone(fields -> {
            fields.name = newName;
        });
    }

    public String getTypeName() {
        return this.type.getSimpleName();
    }

    public String getArity() {
        if (this.minRequired == this.maxRequired) {
            return Integer.toString(this.minRequired);
        }
        if (this.maxRequired == Integer.MAX_VALUE) {
            return String.format("%d+", this.minRequired);
        }
        return String.format("%d..%d", this.minRequired, this.maxRequired);
    }

    public boolean hasCorrectArity(int numValues) {
        return numValues >= this.minRequired && numValues <= this.maxRequired;
    }

    public String toString() {
        return String.format("%s(type=%s)", this.name, this.type.getSimpleName());
    }

    public Parameter withNewType(Class<?> newType) {
        return this.clone(fields -> {
            fields.type = newType;
        });
    }

    public Parameter withValidation(BiFunction<BindingContext, Object, List<Problem>> validationFunction) {
        return this.clone(fields -> {
            fields.validation = validationFunction;
        });
    }

    public List<Problem> validate(BindingContext context, Object boundValue) {
        return this.validation.apply(context, boundValue);
    }

    @NonNull
    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public Optional<BiFunction<BindingContext, Parameter, List<?>>> getDefaultFunction() {
        return this.defaultFunction;
    }

    @Generated
    public int getMinRequired() {
        return this.minRequired;
    }

    @Generated
    public int getMaxRequired() {
        return this.maxRequired;
    }

    @NonNull
    @Generated
    public BiFunction<BindingContext, Object, List<Problem>> getValidation() {
        return this.validation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinRequired() != other.getMinRequired()) {
            return false;
        }
        if (this.getMaxRequired() != other.getMaxRequired()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BiFunction<BindingContext, Object, List<Problem>> this$validation = this.getValidation();
        BiFunction<BindingContext, Object, List<Problem>> other$validation = other.getValidation();
        return !(this$validation == null ? other$validation != null : !this$validation.equals(other$validation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Parameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinRequired();
        result = result * 59 + this.getMaxRequired();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BiFunction<BindingContext, Object, List<Problem>> $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : $validation.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    public static final class MutableFields {
        public String name;
        public Class<?> type;
        public Optional<BiFunction<BindingContext, Parameter, List<?>>> defaultFunction;
        public int minRequired;
        public int maxRequired;
        BiFunction<BindingContext, Object, List<Problem>> validation;

        public MutableFields(Parameter source) {
            this.name = source.name;
            this.type = source.type;
            this.defaultFunction = source.defaultFunction;
            this.minRequired = source.minRequired;
            this.maxRequired = source.maxRequired;
            this.validation = source.validation;
        }
    }
}

