/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.problem.Problem;

public class NoBindingAvailableException
extends RiskscapeException {
    private static final long serialVersionUID = 3144248015313253999L;
    private Class<?> to;
    private Class<?> from;
    private Parameter parameter;
    private Problem withParameterVersion;

    public NoBindingAvailableException(Class<?> from, Class<?> to) {
        super(ParamProblems.get().noBindingAvailable(from, to));
        this.from = from;
        this.to = to;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
        this.withParameterVersion = ParamProblems.get().noBindingAvailableForParameter(parameter, this.from, this.to);
    }

    @Override
    public Problem getProblem() {
        if (this.withParameterVersion != null) {
            return this.withParameterVersion;
        }
        return super.getProblem();
    }

    @Generated
    public Class<?> getTo() {
        return this.to;
    }

    @Generated
    public Class<?> getFrom() {
        return this.from;
    }

    @Generated
    public Parameter getParameter() {
        return this.parameter;
    }
}

