/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class BoundParameters {
    private final ParameterSet boundTo;
    private final BindingContext context;
    private final Map<String, List<?>> valueMap;
    private final Map<String, List<?>> unbound;
    private final List<Problem> validationProblems;

    public Object getValue(String parameterName) {
        Parameter param = this.boundTo.get(parameterName);
        if (param.isMany()) {
            throw new IllegalArgumentException("parameter " + parameterName + " can have many values - use getValues instead");
        }
        List values = this.valueMap.getOrDefault(parameterName, Collections.emptyList());
        return values.isEmpty() ? null : values.get(0);
    }

    public List<?> getValues(String parameterName) {
        this.boundTo.get(parameterName);
        return this.valueMap.getOrDefault(parameterName, Collections.emptyList());
    }

    public Map<String, List<?>> getExtraneous() {
        HashMap clone = new HashMap(this.getUnbound());
        clone.keySet().removeIf(key -> this.boundTo.contains((String)key));
        return clone;
    }

    public boolean isValid() {
        return !Problem.hasErrors(this.validationProblems);
    }

    public <T> ResultOrProblems<T> map(Function<BoundParameters, T> function) {
        if (this.isValid()) {
            return ResultOrProblems.of(function.apply(this));
        }
        return ResultOrProblems.failed(this.validationProblems);
    }

    public <T> ResultOrProblems<T> flatMap(Function<BoundParameters, ResultOrProblems<T>> function) {
        if (this.isValid()) {
            return function.apply(this);
        }
        return ResultOrProblems.failed(this.validationProblems);
    }

    public String toString() {
        return String.format("BoundParameters(%s)", this.valueMap);
    }

    public BoundParameters merge(BoundParameters other) {
        if (other.boundTo != this.boundTo) {
            throw new IllegalArgumentException("Cannot merge if boundTo not the same");
        }
        if (other.context != this.context) {
            throw new IllegalArgumentException("Cannot merge if context not the same");
        }
        HashMap newValueMap = new HashMap();
        HashMap newUnbound = new HashMap();
        newValueMap.putAll(this.valueMap);
        newUnbound.putAll(this.unbound);
        for (Map.Entry<String, List<?>> entry : other.getUnbound().entrySet()) {
            newUnbound.put(entry.getKey(), entry.getValue());
            newValueMap.put(entry.getKey(), other.getValueMap().get(entry.getKey()));
        }
        ArrayList<Problem> collectedErrors = new ArrayList<Problem>();
        for (Parameter param : this.boundTo.getDeclared()) {
            int numValues = newValueMap.getOrDefault(param.getName(), Collections.emptyList()).size();
            if (numValues >= param.getMinRequired() && numValues <= param.getMaxRequired()) continue;
            if (numValues == 0) {
                if (newUnbound.containsKey(param.getName())) {
                    BindingContext ctx = other.getUnbound().containsKey(param.getName()) ? other.context : this.context;
                    for (Object value : (List)newUnbound.get(param.getName())) {
                        ResultOrProblems<?> bindResult = ctx.bind(value, param);
                        if (!bindResult.hasProblems()) continue;
                        collectedErrors.addAll(bindResult.getProblems());
                    }
                    continue;
                }
                collectedErrors.add(GeneralProblems.required(param.getName(), Parameter.class));
                continue;
            }
            collectedErrors.add(ParamProblems.get().wrongNumberGiven(param.getName(), param.getArity(), numValues));
        }
        return new BoundParameters(this.boundTo, this.context, newValueMap, newUnbound, collectedErrors);
    }

    public BoundParameters withMoreProblems(List<Problem> moreProblems) {
        ArrayList<Problem> combinedProblems = new ArrayList<Problem>();
        combinedProblems.addAll(moreProblems);
        combinedProblems.addAll(this.validationProblems);
        return new BoundParameters(this.boundTo, this.context, this.valueMap, this.unbound, combinedProblems);
    }

    @Generated
    public BoundParameters(ParameterSet boundTo, BindingContext context, Map<String, List<?>> valueMap, Map<String, List<?>> unbound, List<Problem> validationProblems) {
        this.boundTo = boundTo;
        this.context = context;
        this.valueMap = valueMap;
        this.unbound = unbound;
        this.validationProblems = validationProblems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundParameters)) {
            return false;
        }
        BoundParameters other = (BoundParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParameterSet this$boundTo = this.getBoundTo();
        ParameterSet other$boundTo = other.getBoundTo();
        if (this$boundTo == null ? other$boundTo != null : !((Object)this$boundTo).equals(other$boundTo)) {
            return false;
        }
        Map<String, List<?>> this$unbound = this.getUnbound();
        Map<String, List<?>> other$unbound = other.getUnbound();
        return !(this$unbound == null ? other$unbound != null : !((Object)this$unbound).equals(other$unbound));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoundParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSet $boundTo = this.getBoundTo();
        result = result * 59 + ($boundTo == null ? 43 : ((Object)$boundTo).hashCode());
        Map<String, List<?>> $unbound = this.getUnbound();
        result = result * 59 + ($unbound == null ? 43 : ((Object)$unbound).hashCode());
        return result;
    }

    @Generated
    public ParameterSet getBoundTo() {
        return this.boundTo;
    }

    @Generated
    public BindingContext getContext() {
        return this.context;
    }

    @Generated
    public Map<String, List<?>> getValueMap() {
        return this.valueMap;
    }

    @Generated
    public Map<String, List<?>> getUnbound() {
        return this.unbound;
    }

    @Generated
    public List<Problem> getValidationProblems() {
        return this.validationProblems;
    }
}

