/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.InvalidBoundParametersException;
import nz.org.riskscape.engine.bind.NoBindingAvailableException;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterBinder;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.problem.ResultOrProblems;

public interface BindingContext {
    public void validateBoundParameters(List<Parameter> var1, Map<String, List<?>> var2) throws InvalidBoundParametersException;

    @Deprecated
    public Object bind(Parameter var1, String var2) throws ParameterBindingException;

    public <T> ResultOrProblems<T> bind(Object var1, Class<T> var2);

    default public <T> List<ResultOrProblems<T>> bindAll(List<?> values, Class<T> expectedType) {
        return values.stream().map(v -> this.bind(v, expectedType)).collect(Collectors.toList());
    }

    default public List<ResultOrProblems<?>> bindAll(List<?> values, Parameter parameter) {
        return values.stream().map(v -> this.bind(v, parameter)).collect(Collectors.toList());
    }

    default public ResultOrProblems<?> bind(Object value, Parameter parameter) {
        try {
            return this.bind(value, parameter.getType()).withMoreProblems(bound -> parameter.validate(this, bound)).composeProblems((s, ps) -> ParamProblems.bindingError(parameter, value, ps));
        }
        catch (NoBindingAvailableException e) {
            e.setParameter(parameter);
            throw e;
        }
    }

    public Optional<ParameterBinder> getBinder(Class<?> var1, Class<?> var2);

    public BindingContext withNewRelativeTo(URI var1);

    public Project getProject();

    public Engine getEngine();

    public URI getRelativeTo();

    public RealizationContext getRealizationContext();

    public Path getTempDirectory();
}

