/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.GeometryInvalidException;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.GeometryReprojectionException;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.UnknownSRIDException;
import nz.org.riskscape.engine.geo.GeometryFixer;
import nz.org.riskscape.engine.geo.GeometryValidation;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.DataUtilities;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.operation.valid.IsValidOp;

public class SRIDSet {
    public static final int UNSET_SRID = 0;
    public static final CoordinateReferenceSystem EPSG4326_LONLAT = SRIDSet.epsgToCrsWithForceXY("EPSG:4326");
    public static final CoordinateReferenceSystem EPSG4326_LATLON = SRIDSet.epsgToCrs("EPSG:4326");
    public static final CoordinateReferenceSystem EPSG2193_NZTM = SRIDSet.epsgToCrs("EPSG:2193");
    public static final CoordinateReferenceSystem WILDCARD_2D = DefaultEngineeringCRS.GENERIC_2D;
    protected final Map<Integer, CoordinateReferenceSystem> crsById = new ConcurrentHashMap<Integer, CoordinateReferenceSystem>();
    protected final Map<CoordinateReferenceSystem, Integer> sridByCrs = new ConcurrentHashMap<CoordinateReferenceSystem, Integer>();
    protected final Map<MetaDataFreeCRS, Integer> sridByMetadataFreeCrs = new ConcurrentHashMap<MetaDataFreeCRS, Integer>();
    private final AtomicInteger nextSridCounter = new AtomicInteger(1);
    private GeometryValidation validationPostReproject = GeometryValidation.OFF;
    private PrecisionModel precisionModel = new PrecisionModel();
    private CoordinateSequenceFactory crsFactory = CoordinateArraySequenceFactory.instance();
    protected final Map<List<Integer>, MathTransform> cachedTransforms = new ConcurrentHashMap<List<Integer>, MathTransform>();
    protected final Map<Integer, GeometryFactory> cachedGeometryFactories = new ConcurrentHashMap<Integer, GeometryFactory>();
    private final ProblemSink problemSink;
    private final GeometryFixer geometryFixer;

    public static CoordinateReferenceSystem epsgToCrs(String epsgCode) {
        return SRIDSet.epsgToCrs(epsgCode, false);
    }

    public static CoordinateReferenceSystem epsgToCrsWithForceXY(String epsgCode) {
        return SRIDSet.epsgToCrs(epsgCode, true);
    }

    private static CoordinateReferenceSystem epsgToCrs(String epsgCode, boolean forceXY) {
        try {
            return CRS.decode((String)epsgCode, (boolean)forceXY);
        }
        catch (FactoryException e) {
            throw new RiskscapeException(Problems.caught(e));
        }
    }

    public SRIDSet() {
        this(ProblemSink.DEVNULL);
    }

    public SRIDSet(ProblemSink problemSink) {
        this(problemSink, GeometryFixer.DEFAULT);
    }

    SRIDSet(ProblemSink problemSink, GeometryFixer geometryFixer) {
        this.problemSink = problemSink;
        this.geometryFixer = geometryFixer;
    }

    public CoordinateReferenceSystem get(int id) {
        CoordinateReferenceSystem found = this.crsById.get(id);
        if (found == null) {
            throw new UnknownSRIDException(id);
        }
        return found;
    }

    public int get(@NonNull FeatureSource<?, ?> fs) {
        if (fs == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        return this.get(fs.getSchema());
    }

    public int get(@NonNull FeatureType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.get(type.getCoordinateReferenceSystem());
    }

    public int get(@NonNull CoordinateReferenceSystem crs) {
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        int srid = this.sridByCrs.computeIfAbsent(crs, newCrs -> this.sridByMetadataFreeCrs.computeIfAbsent(new MetaDataFreeCRS(crs, this.crsHashCode(crs)), newMetaDataFreeCrs -> {
            int nextSrid = this.nextSridCounter.getAndIncrement();
            this.crsById.put(nextSrid, crs);
            return nextSrid;
        }));
        return srid;
    }

    int crsHashCode(CoordinateReferenceSystem crs) {
        try {
            String epsgName = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            CRS.AxisOrder axisOrder = CRS.getAxisOrder((CoordinateReferenceSystem)crs);
            return Objects.hash(epsgName, axisOrder);
        }
        catch (FactoryException e) {
            return crs.hashCode();
        }
    }

    public void clear() {
        this.sridByMetadataFreeCrs.clear();
        this.sridByCrs.clear();
        this.crsById.clear();
        this.cachedTransforms.clear();
        this.cachedGeometryFactories.clear();
        this.nextSridCounter.set(1);
    }

    public CoordinateReferenceSystem get(@NonNull Geometry geometry) {
        if (geometry == null) {
            throw new NullPointerException("geometry is marked non-null but is null");
        }
        return this.get(geometry.getSRID());
    }

    public void remember(@NonNull SimpleFeatureSource fs) {
        if (fs == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        this.get((FeatureSource<?, ?>)fs);
    }

    public Query queryWithHints(@NonNull Query query, @NonNull CoordinateReferenceSystem crs) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        Hints hints = new Hints();
        hints.put((Object)Hints.JTS_GEOMETRY_FACTORY, (Object)this.getGeometryFactory(crs));
        hints.put((Object)Hints.FEATURE_2D, (Object)true);
        Query newQuery = new Query();
        newQuery.setHints(hints);
        return DataUtilities.mixQueries((Query)query, (Query)newQuery, null);
    }

    public MathTransform getReprojectionTransform(int sourceSrid, int targetSrid) {
        List<Integer> cacheKey = Arrays.asList(sourceSrid, targetSrid);
        return this.cachedTransforms.computeIfAbsent(cacheKey, key -> {
            CoordinateReferenceSystem sourceCrs = this.get(sourceSrid);
            CoordinateReferenceSystem targetCrs = this.get(targetSrid);
            try {
                return CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)targetCrs, (boolean)false);
            }
            catch (FactoryException e) {
                try {
                    MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)targetCrs, (boolean)true);
                    if (!transform.isIdentity()) {
                        this.problemSink.log(GeometryProblems.get().reprojectionIgnoringDatumShift(sourceCrs, targetCrs));
                    }
                    return transform;
                }
                catch (FactoryException ee) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public Geometry reproject(Geometry geom, int targetSrid) throws GeometryReprojectionException {
        if (geom.getSRID() == targetSrid || geom.getSRID() == 0) {
            return geom;
        }
        CoordinateReferenceSystem targetCrs = this.get(targetSrid);
        CoordinateReferenceSystem sourceCrs = this.get(geom.getSRID());
        try {
            MathTransform transform = this.getReprojectionTransform(geom.getSRID(), targetSrid);
            return this.reproject(geom, transform, sourceCrs, targetCrs);
        }
        catch (IllegalArgumentException | TransformException ex) {
            throw new GeometryReprojectionException("Geometry could not be reprojected", geom, targetCrs, ex);
        }
    }

    public Geometry reproject(Geometry geom, MathTransform transform, CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCrs) throws TransformException {
        IsValidOp isValidOp;
        GeometryFactory targetFactory = this.getGeometryFactory(targetCrs);
        Geometry reprojected = targetFactory.createGeometry(JTS.transform((Geometry)geom, (MathTransform)transform));
        if (this.validationPostReproject != GeometryValidation.OFF && !(isValidOp = new IsValidOp(reprojected)).isValid()) {
            Geometry fixed = this.geometryFixer.fix(reprojected);
            if (fixed != null) {
                this.problemSink.log(GeometryProblems.get().fixedInvalidPostReprojection(sourceCrs, targetCrs, reprojected, fixed));
                return fixed;
            }
            if (geom.isValid()) {
                Problem invalidProblem = GeometryProblems.get().invalidPostReprojection(sourceCrs, targetCrs);
                if (this.validationPostReproject == GeometryValidation.ERROR) {
                    throw new GeometryInvalidException(invalidProblem);
                }
                this.problemSink.log(invalidProblem.withSeverity(Problem.Severity.WARNING));
            }
        }
        return reprojected;
    }

    public boolean requiresReprojection(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        return !CRS.equalsIgnoreMetadata((Object)crs1, (Object)crs2);
    }

    public GeometryFactory getGeometryFactory(CoordinateReferenceSystem crs) {
        return this.cachedGeometryFactories.computeIfAbsent(this.get(crs), key -> new GeometryFactory(this.precisionModel, key.intValue(), this.crsFactory));
    }

    @Generated
    public GeometryValidation getValidationPostReproject() {
        return this.validationPostReproject;
    }

    @Generated
    public void setValidationPostReproject(GeometryValidation validationPostReproject) {
        this.validationPostReproject = validationPostReproject;
    }

    private static class MetaDataFreeCRS {
        private final CoordinateReferenceSystem crs;
        private final int hashCode;

        MetaDataFreeCRS(CoordinateReferenceSystem crs, int hashCode) {
            this.crs = crs;
            this.hashCode = hashCode;
        }

        public boolean equals(Object obj) {
            return CRS.equalsIgnoreMetadata((Object)this.crs, (Object)((MetaDataFreeCRS)obj).crs);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

