/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.util.Optional;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class RiskscapeException
extends RuntimeException {
    private final Problems problem;

    @Deprecated
    public RiskscapeException(String message) {
        super(message);
        this.problem = Problems.NONE;
    }

    @Deprecated
    public RiskscapeException(String message, Throwable cause) {
        super(message, cause);
        this.problem = Problems.NONE;
    }

    public RiskscapeException(Problems problem) {
        this(problem, null);
    }

    public RiskscapeException(Problems problem, Throwable cause) {
        super(problem.toString(), cause);
        this.problem = problem;
    }

    public boolean hasProblem() {
        return this.problem.isPresent();
    }

    public Problem getProblem() {
        return this.problem.toProblem().orElse(null);
    }

    @Override
    public Throwable getCause() {
        Throwable ex = super.getCause();
        if (ex == null) {
            ex = this.problem.stream().flatMap(p -> Optional.ofNullable(p.findAnyException()).stream()).findFirst().orElse(null);
        }
        return ex;
    }

    public Problems getProblems() {
        return this.problem;
    }
}

