/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsUtils.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String[] WINDOWS_CODE_PAGE_COMMAND = new String[]{"PowerShell", "-Command", "& {[console]::OutputEncoding.CodePage}"};
    private static final int WINDOWS_UTF8_CODE_PAGE = 65001;
    public static final String LINE_SEPARATOR = String.format("%n", new Object[0]);

    public static boolean isLinux() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isWindows() {
        return OS.startsWith("win");
    }

    private static Optional<Integer> getCmdOutputAsInt(String[] cmd) {
        try {
            Process p = new ProcessBuilder(cmd).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
            int exitCode = p.waitFor();
            if (exitCode == 0) {
                return Optional.of(Integer.parseInt(new BufferedReader(new InputStreamReader(p.getInputStream())).readLine()));
            }
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static String fixPathSep(String path) {
        return path.replace("/", File.separator);
    }

    public static String fps(String path) {
        return OsUtils.fixPathSep(path);
    }

    private static boolean setWindowsCodePage(int codePage) {
        String[] cmd = new String[]{"cmd", "/c", "chcp", String.valueOf(codePage)};
        try {
            Process p = new ProcessBuilder(cmd).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
            int exitCode = p.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            return false;
        }
    }

    public static void checkConsoleCompatibility() {
        int codePage;
        if (OsUtils.isWindows() && System.getProperty("file.encoding").equals("UTF-8") && (codePage = OsUtils.getCmdOutputAsInt(WINDOWS_CODE_PAGE_COMMAND).orElse(65001).intValue()) != 65001) {
            if (OsUtils.setWindowsCodePage(65001)) {
                log.warn("Changed console to use UTF-8 encoding (was chcp {})", (Object)codePage);
            } else {
                log.warn("Could not change console code page. For best results when rendering output, run: chcp 65001");
            }
        }
    }

    @Generated
    public static String getOS() {
        return OS;
    }
}

