/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.ConstructionCallback;
import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.ObjectAlreadyExistsException;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.ResultOrProblems;
import org.apache.commons.text.similarity.CosineSimilarity;

public interface IdentifiedCollection<T extends Identified> {
    public void add(T var1) throws ObjectAlreadyExistsException;

    public void add(T var1, Resource var2) throws ObjectAlreadyExistsException;

    public void add(String var1, Resource var2, ConstructionCallback<T> var3) throws ObjectAlreadyExistsException;

    public void addAll(Collection<T> var1) throws ObjectAlreadyExistsException;

    public void addAll(Collection<T> var1, Resource var2) throws ObjectAlreadyExistsException;

    public List<T> getAll();

    public List<Reference<T>> getReferences();

    @Deprecated
    default public T get(String id) throws NoSuchObjectException, FailedObjectException {
        return this.get(id, null);
    }

    public T get(String var1, ProblemSink var2) throws NoSuchObjectException, FailedObjectException;

    public ResultOrProblems<T> getOr(String var1);

    public Class<? extends Identified> getCollectionClass();

    public Optional<ResultOrProblems<T>> getResult(String var1);

    public List<Pair<String, List<Problem>>> getAllProblems();

    public boolean containsKey(String var1);

    public boolean remove(String var1);

    public void clear();

    public boolean isEmpty();

    public List<String> getSimilarIds(String var1);

    public static class Base<T extends Identified>
    implements IdentifiedCollection<T> {
        private static final double SIMILARITY_THRESHOLD = 0.5;
        private static final int SIMILARITY_MAX_OPTIONS = 6;
        private final Class<T> collectionClass;
        protected final Map<String, Handle> results = new LinkedHashMap<String, Handle>();

        public Base() {
            this.collectionClass = this.determineCollectionClass();
            if (this.collectionClass.equals(Identified.class)) {
                throw new AssertionError((Object)"Identified classes must be declared with a specific type");
            }
        }

        public Base(Class<T> collectionClass) {
            this.collectionClass = collectionClass;
        }

        @Override
        public void add(final String identifier, Resource resource, ConstructionCallback<T> builder) {
            Handle existing = this.results.putIfAbsent(identifier, new Handle(identifier, resource, builder));
            if (existing != null) {
                Object existingThing = !existing.isPresent() ? new Identified(){

                    @Override
                    public String getId() {
                        return identifier;
                    }

                    @Override
                    public Class<? extends Identified> getIdentifiedClass() {
                        return this.getCollectionClass();
                    }
                } : existing.get();
                throw new ObjectAlreadyExistsException((Identified)existingThing, existing.getResource(), resource);
            }
        }

        @Override
        public boolean remove(String id) {
            return this.results.remove(id) != null;
        }

        @Override
        public void add(@NonNull T identified) {
            if (identified == null) {
                throw new NullPointerException("identified is marked non-null but is null");
            }
            this.add(identified, Resource.UNKNOWN);
        }

        @Override
        public void add(@NonNull T identified, @NonNull Resource source) {
            if (identified == null) {
                throw new NullPointerException("identified is marked non-null but is null");
            }
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.add(identified.getId(), source, () -> ResultOrProblems.of(identified));
        }

        @Override
        public void addAll(@NonNull Collection<T> identifieds) {
            if (identifieds == null) {
                throw new NullPointerException("identifieds is marked non-null but is null");
            }
            identifieds.forEach(i -> this.add(i));
        }

        @Override
        public void addAll(Collection<T> identifieds, Resource source) throws ObjectAlreadyExistsException {
            identifieds.forEach(i -> this.add(i, source));
        }

        @Override
        public List<T> getAll() {
            return ImmutableList.copyOf((Collection)this.results.values().stream().filter(Handle::isPresent).map(Handle::getWithProblemsIgnored).collect(Collectors.toList()));
        }

        @Override
        public List<Pair<String, List<Problem>>> getAllProblems() {
            ArrayList<Pair<String, List<Problem>>> all = new ArrayList<Pair<String, List<Problem>>>(this.results.size() / 2);
            for (Handle result : this.results.values()) {
                if (!result.isFailed()) continue;
                all.add(Pair.of(result.id, result.getResult().getProblems()));
            }
            return all;
        }

        @Override
        public List<Reference<T>> getReferences() {
            return ImmutableList.copyOf(this.results.values());
        }

        @Override
        public T get(@NonNull String id, ProblemSink problemSink) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            Handle handle = this.results.get(id);
            if (handle == null) {
                throw new NoSuchObjectException(id, this);
            }
            if (handle.isFailed()) {
                if (handle.resource == Resource.UNKNOWN) {
                    throw new FailedObjectException(id, this.collectionClass, handle.getProblems());
                }
                throw new FailedObjectException(id, this.collectionClass, handle.resource.getLocation(), handle.getProblems());
            }
            if (problemSink != null) {
                handle.drainWarnings(problemSink);
            }
            return (T)handle.get();
        }

        @Override
        public ResultOrProblems<T> getOr(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            try {
                LinkedList<Problem> collectedWarnings = new LinkedList<Problem>();
                return ResultOrProblems.of(this.get(id, p -> collectedWarnings.add(p)), collectedWarnings);
            }
            catch (FailedObjectException | NoSuchObjectException e) {
                return ResultOrProblems.failed(e.getProblem());
            }
        }

        public Class<T> determineCollectionClass() {
            Class rawType = TypeToken.of(this.getClass()).resolveType(Base.class.getTypeParameters()[0]).getRawType();
            return rawType;
        }

        @Override
        public Optional<ResultOrProblems<T>> getResult(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            Handle result = this.results.get(id);
            return Optional.ofNullable(result).map(Handle::getResult);
        }

        @Override
        public boolean containsKey(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            return this.results.containsKey(id);
        }

        @Override
        public boolean isEmpty() {
            return this.results.isEmpty();
        }

        @Override
        public void clear() {
            this.results.clear();
        }

        protected void removeAll(@NonNull Collection<T> items) {
            if (items == null) {
                throw new NullPointerException("items is marked non-null but is null");
            }
            for (Identified item : items) {
                this.results.remove(item.getId());
            }
        }

        private static Map<CharSequence, Integer> countNgramFrequency(String sequence, int degree) {
            HashMap<CharSequence, Integer> m = new HashMap<CharSequence, Integer>();
            sequence = sequence.toLowerCase();
            int i = 0;
            while (i + degree <= sequence.length()) {
                String gram;
                m.put(gram, 1 + (m.containsKey(gram = sequence.substring(i, i + degree)) ? (Integer)m.get(gram) : 0));
                ++i;
            }
            return m;
        }

        @Override
        public List<String> getSimilarIds(String candidate) {
            ArrayList<Pair<String, Double>> scoredAlternatives = new ArrayList<Pair<String, Double>>(this.results.size());
            CosineSimilarity similarity = new CosineSimilarity();
            Map<CharSequence, Integer> leftVector = Base.countNgramFrequency(candidate, 2);
            for (String alternative : this.results.keySet()) {
                Map<CharSequence, Integer> rightVector = Base.countNgramFrequency(alternative, 2);
                double score = similarity.cosineSimilarity(leftVector, rightVector);
                scoredAlternatives.add(Pair.of(alternative, score));
            }
            scoredAlternatives.sort((lhs, rhs) -> ((Double)rhs.getRight()).compareTo((Double)lhs.getRight()));
            List alternatives = scoredAlternatives.stream().filter(pair -> (Double)pair.getRight() > 0.5).map(Pair::getLeft).collect(Collectors.toList());
            return alternatives.subList(0, Math.min(6, alternatives.size()));
        }

        @Override
        @Generated
        public Class<T> getCollectionClass() {
            return this.collectionClass;
        }

        protected class Handle
        implements Reference<T> {
            private final String id;
            private final Resource resource;
            private final ConstructionCallback<T> callback;
            private ResultOrProblems<T> result;

            public boolean isPresent() {
                return this.getResult().isPresent();
            }

            @Override
            public ResultOrProblems<T> getResult() {
                if (this.result == null) {
                    this.result = this.callback.create();
                }
                return this.result;
            }

            @Override
            public Class<T> getIdentifiedClass() {
                return Base.this.collectionClass;
            }

            @Override
            public T get() {
                if (this.isFailed()) {
                    throw new FailedObjectException(this.id, this.getIdentifiedClass(), this.getProblems());
                }
                return (Identified)this.getResult().get();
            }

            public T getWithProblemsIgnored() {
                return (Identified)this.getResult().getWithProblemsIgnored();
            }

            @Override
            public void drainWarnings(Consumer<Problem> problemConsumer) {
                if (this.result != null) {
                    this.result = this.result.drainWarnings(problemConsumer);
                }
            }

            public boolean isFailed() {
                return this.getResult().hasErrors();
            }

            public List<Problem> getProblems() {
                return this.getResult().getProblems();
            }

            @Generated
            public Handle(String id, Resource resource, ConstructionCallback<T> callback) {
                this.id = id;
                this.resource = resource;
                this.callback = callback;
            }

            @Generated
            public String toString() {
                return "IdentifiedCollection.Base.Handle(id=" + this.getId() + ", resource=" + String.valueOf(this.getResource()) + ", callback=" + String.valueOf(this.getCallback()) + ", result=" + String.valueOf(this.getResult()) + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Handle)) {
                    return false;
                }
                Handle other = (Handle)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                return !(this$id == null ? other$id != null : !this$id.equals(other$id));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Handle;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }

            @Override
            @Generated
            public Resource getResource() {
                return this.resource;
            }

            @Generated
            public ConstructionCallback<T> getCallback() {
                return this.callback;
            }
        }
    }
}

