/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import nz.org.riskscape.engine.BuildInfo;
import nz.org.riskscape.engine.Diagnostics;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.IdentifiedLocator;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterBinder;
import nz.org.riskscape.engine.data.BookmarkResolvers;
import nz.org.riskscape.engine.function.FunctionFramework;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.io.TupleStorage;
import nz.org.riskscape.engine.model.ModelFramework;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.PipelineOutputStores;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.PipelineSteps;
import nz.org.riskscape.engine.plugin.ExtensionPoints;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.resource.ResourceFactory;
import nz.org.riskscape.engine.types.TypeRegistry;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.filter.FilterFactory;

public interface Engine
extends IdentifiedLocator,
AutoCloseable {
    public static final URI EMPTY_PROJECT_LOCATION = URI.create("null:null");

    public BookmarkResolvers getBookmarkResolvers();

    public PipelineSteps getPipelineSteps();

    public FilterFactory getFilterFactory();

    public TypeRegistry getTypeRegistry();

    public ResourceFactory getResourceFactory();

    public TupleStorage getTupleStorage();

    public ProblemSink getProblemSink();

    public IdentifiedCollection<ParameterBinder> getBinders();

    public IdentifiedCollection<Format> getFormats();

    public Messages getMessages();

    public PipelineExecutor getPipelineExecutor();

    public BuildInfo getBuildInfo();

    public Diagnostics getDiagnostics();

    public IdentifiedCollection<FunctionFramework> getFunctionFrameworks();

    public <T> List<T> getFeaturesOfType(Class<T> var1);

    public ExtensionPoints getExtensionPoints();

    public IdentifiedCollection<ModelFramework> getModelFrameworks();

    public PipelineOutputStores getPipelineOutputStores();

    public ResultOrProblems<Project> buildProject(URI var1, Consumer<Problem> var2);

    public Project emptyProject();

    public List<Plugin> getPlugins();

    public boolean isBetaPluginEnabled();

    public Path getUserHomeDirectory();

    public Path getTempDirectory();

    default public List<String> getSetting(String settingsKey) {
        return Collections.emptyList();
    }

    @Override
    public void close();

    default public BindingContext newBindingContext() {
        return this.emptyProject().newBindingContext();
    }

    public static interface Writeable
    extends Engine {
        public void registerCollection(IdentifiedCollection<?> var1);
    }
}

