/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    public static final BuildInfo UNKNOWN = new BuildInfo("unknown", "", new Date(0L));
    private static BuildInfo instance;
    private final String version;
    private final String commitInfo;
    private final Date buildTime;

    public static BuildInfo getBuildInfo() {
        if (instance == null) {
            try {
                Properties buildProps = new Properties();
                buildProps.load(BuildInfo.class.getResourceAsStream("/build.properties"));
                instance = new BuildInfo(buildProps);
            }
            catch (Exception e) {
                System.err.println("Failed to load build.properties - could not determine build information");
                instance = UNKNOWN;
            }
        }
        return instance;
    }

    public BuildInfo(Properties buildProps) {
        this.version = buildProps.getProperty("Riskscape-Version", "unknown");
        this.commitInfo = buildProps.getProperty("Riskscape-Commit-Info", "unknown");
        this.buildTime = this.readDate(buildProps.getProperty("Buildtime", "unknown"));
    }

    private Date readDate(String isoOffsetString) {
        try {
            OffsetDateTime builtAt = OffsetDateTime.parse(isoOffsetString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return Date.from(builtAt.toInstant());
        }
        catch (Exception e) {
            log.error("Could not read Buildtime '{}'", (Object)isoOffsetString);
            return null;
        }
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getCommitInfo() {
        return this.commitInfo;
    }

    @Generated
    public Date getBuildTime() {
        return this.buildTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildInfo)) {
            return false;
        }
        BuildInfo other = (BuildInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$commitInfo = this.getCommitInfo();
        String other$commitInfo = other.getCommitInfo();
        if (this$commitInfo == null ? other$commitInfo != null : !this$commitInfo.equals(other$commitInfo)) {
            return false;
        }
        Date this$buildTime = this.getBuildTime();
        Date other$buildTime = other.getBuildTime();
        return !(this$buildTime == null ? other$buildTime != null : !((Object)this$buildTime).equals(other$buildTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $commitInfo = this.getCommitInfo();
        result = result * 59 + ($commitInfo == null ? 43 : $commitInfo.hashCode());
        Date $buildTime = this.getBuildTime();
        result = result * 59 + ($buildTime == null ? 43 : ((Object)$buildTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BuildInfo(version=" + this.getVersion() + ", commitInfo=" + this.getCommitInfo() + ", buildTime=" + String.valueOf(this.getBuildTime()) + ")";
    }

    @Generated
    public BuildInfo(String version, String commitInfo, Date buildTime) {
        this.version = version;
        this.commitInfo = commitInfo;
        this.buildTime = buildTime;
    }
}

