/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.LexerProblems;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;

@FunctionalInterface
public interface TokenMatcher {
    public static final Set<Character> DEFAULT_QUOTES = Sets.newHashSet((Object[])new Character[]{Character.valueOf('\''), Character.valueOf('\"')});
    public static final String[] LINE_ENDINGS = new String[]{"\r\n", "\r", "\n"};

    public static TokenMatcher forChar(char character) {
        return (tokenType, source, position) -> {
            if (source.charAt(position) == character) {
                return new Token(tokenType, source, position, position + 1, Character.toString(character));
            }
            return null;
        };
    }

    public static TokenMatcher forString(String string) {
        return (tokenType, source, position) -> {
            if (source.regionMatches(position, string, 0, string.length())) {
                return new Token(tokenType, source, position, position + string.length(), string);
            }
            return null;
        };
    }

    public static TokenMatcher forIString(String string) {
        return (tokenType, source, position) -> {
            if (source.regionMatches(true, position, string, 0, string.length())) {
                return new Token(tokenType, source, position, position + string.length(), string);
            }
            return null;
        };
    }

    public static TokenMatcher forPattern(String regex) {
        return TokenMatcher.forPattern(Pattern.compile(regex));
    }

    public static TokenMatcher forPattern(Pattern pattern) {
        return (tokenType, source, position) -> {
            Matcher match = pattern.matcher(source.substring(position));
            if (match.find()) {
                String tokenValue = match.groupCount() == 1 ? match.group(1) : match.group();
                return new Token(tokenType, source, position, match.end() + position, tokenValue);
            }
            return null;
        };
    }

    public static TokenMatcher forQuotedString() {
        return TokenMatcher.forQuotedString(DEFAULT_QUOTES);
    }

    public static TokenMatcher forQuotedString(char quoteChar) {
        return TokenMatcher.forQuotedString(Collections.singleton(Character.valueOf(quoteChar)));
    }

    public static TokenMatcher forQuotedString(Set<Character> quoteWith) {
        return (tokenType, source, position) -> {
            char character = source.charAt(position);
            if (quoteWith.contains(Character.valueOf(character))) {
                int curPosition;
                char mode = character;
                int escapeChar = 92;
                StringBuilder builder = new StringBuilder();
                boolean lastWasEscape = false;
                for (curPosition = position + 1; curPosition < source.length(); ++curPosition) {
                    char curChar = source.charAt(curPosition);
                    if (curChar == '\\') {
                        if (lastWasEscape) {
                            builder.append('\\');
                            lastWasEscape = false;
                            continue;
                        }
                        lastWasEscape = true;
                        continue;
                    }
                    if (lastWasEscape) {
                        if (curChar == mode) {
                            builder.append(curChar);
                        } else {
                            builder.append('\\');
                            builder.append(curChar);
                        }
                    } else {
                        if (curChar == mode) {
                            return new Token(tokenType, source, position, curPosition + 1, builder.toString());
                        }
                        builder.append(curChar);
                    }
                    lastWasEscape = false;
                }
                throw new LexerException(LexerProblems.get().eofInString(curPosition));
            }
            return null;
        };
    }

    public Token match(TokenType var1, String var2, int var3);

    public static TokenMatcher forLineComment(String startsWith) {
        return (type, source, position) -> {
            if (source.charAt(position) == startsWith.charAt(0) && source.substring(position, position + startsWith.length()).equals(startsWith)) {
                int i;
                block0: for (i = position; i < source.length(); ++i) {
                    for (int j = 0; j < LINE_ENDINGS.length; ++j) {
                        String lineEnding = LINE_ENDINGS[j];
                        if (source.charAt(i) == lineEnding.charAt(0) && source.substring(i, i + lineEnding.length()).equals(lineEnding)) break block0;
                    }
                }
                return new Token(type, source, position, i, source.substring(position + startsWith.length(), i));
            }
            return null;
        };
    }

    default public Optional<String> getKeyword() {
        return Optional.empty();
    }
}

