/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.dsl.InconsistentIndentException;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.TokenType;

public class Token {
    public static final Token UNKNOWN_LOCATION = Token.token(null, "");
    public final TokenType type;
    public final String source;
    public final int begin;
    public final int end;
    private Token previous;
    private Token next;
    public final String value;
    private SourceLocation location;

    public static Token eof(Lexer.Tokens<?> tokens, String source) {
        return new Token((TokenType)tokens.eofToken, source, source.length(), source.length(), "");
    }

    public static Token token(TokenType tokenType, String value) {
        return new Token(tokenType, value, 0, value.length(), value);
    }

    public Token(TokenType type, String source, int begin, int end, String value) {
        this.type = type;
        this.begin = begin;
        this.end = end;
        this.source = source;
        this.value = value;
        this.location = SourceLocation.unlined(begin);
    }

    public Token getStartOfLine() {
        if (this.previous == null) {
            return this;
        }
        return this.previous.getStartOfLine();
    }

    public List<Token> getIndents() {
        Token ptr = this.getStartOfLine();
        LinkedList<Token> beingBuilt = new LinkedList<Token>();
        while (ptr != null && ptr.isWhitespace()) {
            beingBuilt.add(ptr);
            ptr = ptr.next;
        }
        return beingBuilt;
    }

    public int countIndents() {
        Token ptr = this.getStartOfLine();
        int counter = 0;
        while (ptr != null && ptr.isWhitespace()) {
            ++counter;
            ptr = ptr.next;
        }
        return counter;
    }

    public boolean isWhitespace() {
        return this.type.isWhitespace();
    }

    public String toString() {
        return "['" + this.value + "' type=" + String.valueOf(this.type) + " (" + String.valueOf(this.location) + ")]";
    }

    public String getPosition() {
        return this.begin + "..." + this.end;
    }

    public String rawValue() {
        return this.source.substring(this.begin, this.end);
    }

    public boolean moreIndented(Token compareTo) {
        Iterator<Token> myIndents = this.getIndents().iterator();
        Iterator<Token> theirIndents = compareTo.getIndents().iterator();
        int myCount = 0;
        int theirCount = 0;
        Token none = Token.token(compareTo.type, "");
        while (myIndents.hasNext() || theirIndents.hasNext()) {
            Token theirs;
            Token mine = myIndents.hasNext() ? myIndents.next() : none;
            Token token = theirs = theirIndents.hasNext() ? theirIndents.next() : none;
            if (mine != none && theirs != none && mine.type != theirs.type) {
                throw new InconsistentIndentException(mine, theirs);
            }
            myCount += mine.value.length();
            theirCount += theirs.value.length();
        }
        return myCount > theirCount;
    }

    void setPrevious(Token toSet) {
        this.previous = toSet;
        if (toSet != null) {
            toSet.next = this;
        }
    }

    public boolean isSourceSingleLine() {
        return this.source.trim().indexOf("\n") == -1;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TokenType this$type = this.getType();
        TokenType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public TokenType getType() {
        return this.type;
    }

    @Generated
    Token getPrevious() {
        return this.previous;
    }

    @Generated
    Token getNext() {
        return this.next;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public SourceLocation getLocation() {
        return this.location;
    }

    @Generated
    public void setLocation(SourceLocation location) {
        this.location = location;
    }
}

