/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class SourceLocation
implements Comparable<SourceLocation> {
    public static final SourceLocation START = new SourceLocation(0, 1, 1);
    private final int index;
    private final int line;
    private final int column;

    public static Optional<SourceLocation> parseUriFragment(String fragment) {
        if (fragment == null || !fragment.startsWith("I")) {
            return Optional.empty();
        }
        List<String> bits = List.of(fragment.substring(1).split("[ILC]"));
        if (bits.size() != 3) {
            return Optional.empty();
        }
        try {
            Iterator<Integer> ints = bits.stream().map(Integer::parseInt).toList().iterator();
            return Optional.of(new SourceLocation(ints.next(), ints.next(), ints.next()));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static SourceLocation unlined(int index) {
        return new SourceLocation(index, -1, index + 1);
    }

    public static SourceLocation index(int index) {
        return new SourceLocation(index, 1, index + 1);
    }

    public String toString() {
        if (this.isUnlined()) {
            return String.format("index %d (unlined)", this.index);
        }
        return String.format("line %d, column %d", this.line, this.column);
    }

    public SourceLocation advance(int moveByChars) {
        return new SourceLocation(this.index + moveByChars, this.line, this.column + moveByChars);
    }

    public SourceLocation newline() {
        if (this.isUnlined()) {
            throw new IllegalStateException("Unlined locations can't do newlines");
        }
        return new SourceLocation(this.index, this.line + 1, 1);
    }

    public boolean isUnlined() {
        return this.line == -1;
    }

    public String toUriFragment() {
        return String.format("I%dL%dC%d", this.index, this.line, this.column);
    }

    public URI addToUri(URI existing) {
        Object uriString = existing.toString();
        int lastIndexOf = ((String)uriString).lastIndexOf(35);
        uriString = lastIndexOf >= 0 ? ((String)uriString).substring(0, lastIndexOf + 1) + this.toUriFragment() : (String)uriString + "#" + this.toUriFragment();
        return URI.create((String)uriString);
    }

    @Override
    public int compareTo(SourceLocation rhs) {
        if (this.isUnlined() != rhs.isUnlined()) {
            throw new IllegalArgumentException("Can not compare source locations if one is lined and the other not");
        }
        if (this.isUnlined()) {
            return Integer.compare(this.index, rhs.index);
        }
        int lineCmp = Integer.compare(this.line, rhs.line);
        if (lineCmp != 0) {
            return lineCmp;
        }
        return Integer.compare(this.column, rhs.column);
    }

    @Generated
    public SourceLocation(int index, int line, int column) {
        this.index = index;
        this.line = line;
        this.column = column;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public int getColumn() {
        return this.column;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceLocation)) {
            return false;
        }
        SourceLocation other = (SourceLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        return this.getColumn() == other.getColumn();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceLocation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getLine();
        result = result * 59 + this.getColumn();
        return result;
    }
}

