/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import lombok.Generated;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;

public class LexingStream {
    private final String source;
    private int index = 0;
    private int line = 1;
    private int col = 1;
    private SourceLocation location;
    private char lastChar = '\u0000';

    public CharSequence asCharSequence() {
        return new MovingSequence(this.source, this.index, 0);
    }

    public char peek() {
        try {
            return this.source.charAt(this.index);
        }
        catch (IndexOutOfBoundsException e) {
            return '\u0000';
        }
    }

    public char next() {
        char ch;
        try {
            ch = this.source.charAt(this.index++);
        }
        catch (IndexOutOfBoundsException e) {
            --this.index;
            return '\u0000';
        }
        this.location = null;
        ++this.col;
        if (ch == '\n') {
            if (this.lastChar != '\r') {
                ++this.line;
                this.col = 1;
            } else {
                --this.col;
            }
        }
        if (ch == '\r') {
            ++this.line;
            this.col = 1;
        }
        this.lastChar = ch;
        return ch;
    }

    public boolean nextIf(char charAt) {
        if (this.peek() == charAt) {
            this.next();
            return true;
        }
        return false;
    }

    public char nextIfOneOf(char[] chars) {
        char ch = this.peek();
        for (char c : chars) {
            if (ch != c) continue;
            return this.next();
        }
        return '\u0000';
    }

    public void skipWhile(char[] chars) {
        block0: while (true) {
            char ch = this.peek();
            for (char c : chars) {
                if (ch != c) continue;
                this.next();
                continue block0;
            }
            break;
        }
    }

    public SourceLocation nextIf(String string) {
        int matchIdx = 0;
        int len = string.length();
        SourceLocation startLocation = this.getLocation();
        while (matchIdx < len) {
            if (this.nextIf(string.charAt(matchIdx++))) continue;
            this.rewind(startLocation);
            return null;
        }
        return startLocation;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isEof() {
        return this.source.length() == this.index;
    }

    public void rewind(SourceLocation moveTo) {
        if (this.index == moveTo.getIndex()) {
            return;
        }
        if (moveTo.getIndex() > this.index) {
            throw new IllegalArgumentException("Can not move forward using this method");
        }
        this.index = moveTo.getIndex();
        this.line = moveTo.getLine();
        this.col = moveTo.getColumn();
        this.location = moveTo;
    }

    public String getRemaining() {
        return this.source.substring(this.index);
    }

    public SourceLocation getLocation() {
        if (this.location == null) {
            this.location = new SourceLocation(this.index, this.line, this.col);
        }
        return this.location;
    }

    public Token newToken(TokenType tokenType, int length, String tokenValue) {
        Token token = new Token(tokenType, this.source, this.index, this.index + length, tokenValue);
        token.setLocation(this.getLocation());
        this.move(length);
        return token;
    }

    public Token newToken(TokenType tokenType, SourceLocation startLocation, String tokenValue) {
        Token token = new Token(tokenType, this.source, startLocation.getIndex(), this.index, tokenValue);
        token.setLocation(startLocation);
        return token;
    }

    private void move(int length) {
        while (length-- > 0) {
            this.next();
        }
    }

    @Generated
    public LexingStream(String source) {
        this.source = source;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public char getLastChar() {
        return this.lastChar;
    }

    private static class MovingSequence
    implements CharSequence {
        private final String source;
        private final int start;
        private final int shrink;

        @Override
        public char charAt(int index) {
            return this.source.charAt(index + this.start);
        }

        @Override
        public int length() {
            return this.source.length() - this.start - this.shrink;
        }

        @Override
        public String toString() {
            return this.source.substring(this.start, this.source.length() + this.shrink);
        }

        @Override
        public CharSequence subSequence(int newStart, int end) {
            int shrinkBy = this.length() - end;
            return new MovingSequence(this.source, this.start + newStart, this.shrink - shrinkBy);
        }

        @Generated
        public MovingSequence(String source, int start, int shrink) {
            this.source = source;
            this.start = start;
            this.shrink = shrink;
        }
    }
}

