/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.LexerProblems;
import nz.org.riskscape.dsl.LexingStream;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenMatcher;
import nz.org.riskscape.dsl.TokenType;

public interface LexingMatcher {
    public static final char[] DEFAULT_QUOTES = new char[]{'\'', '\"'};
    public static final String[] LINE_ENDINGS = new String[]{"\r\n", "\r", "\n"};

    public static LexingMatcher wrap(TokenMatcher oldMatcher) {
        return (type, stream) -> {
            Token match = oldMatcher.match(type, stream.getSource(), stream.getIndex());
            if (match != null) {
                match.setLocation(stream.getLocation());
                int consumed = match.end - match.begin;
                while (consumed-- != 0) {
                    stream.next();
                }
            }
            return match;
        };
    }

    public static LexingMatcher forChar(char character) {
        String value = Character.toString(character).intern();
        return (tokenType, stream) -> {
            if (stream.peek() == character) {
                return stream.newToken(tokenType, 1, value);
            }
            return null;
        };
    }

    public static LexingMatcher forWhitespace(String whitespaceChars) {
        char[] ws = whitespaceChars.toCharArray();
        return (tokenType, stream) -> {
            SourceLocation startsAt = stream.getLocation();
            stream.skipWhile(ws);
            if (startsAt.getIndex() == stream.getIndex()) {
                return null;
            }
            return stream.newToken(tokenType, startsAt, "");
        };
    }

    public static LexingMatcher forString(String string) {
        return (tokenType, stream) -> {
            int matchIdx = 0;
            int len = string.length();
            SourceLocation startLocation = stream.getLocation();
            while (matchIdx < len) {
                if (stream.nextIf(string.charAt(matchIdx++))) continue;
                return null;
            }
            return stream.newToken(tokenType, startLocation, string);
        };
    }

    public static LexingMatcher forPattern(String regex) {
        return LexingMatcher.forPattern(Pattern.compile(regex));
    }

    public static LexingMatcher forPattern(Pattern pattern) {
        return (tokenType, stream) -> {
            Matcher match = pattern.matcher(stream.asCharSequence());
            if (match.find()) {
                String tokenValue = match.groupCount() == 1 ? match.group(1) : match.group();
                return stream.newToken(tokenType, match.end(), tokenValue);
            }
            return null;
        };
    }

    public static LexingMatcher forQuotedString() {
        return LexingMatcher.forQuotedString(DEFAULT_QUOTES);
    }

    public static LexingMatcher forQuotedString(char quoteChar) {
        return LexingMatcher.forQuotedString(new char[]{quoteChar});
    }

    public static LexingMatcher forQuotedString(char[] quoteWith) {
        return (tokenType, stream) -> {
            char character = stream.peek();
            char mode = '\u0000';
            for (char c : quoteWith) {
                if (character != c) continue;
                mode = character;
                break;
            }
            if (mode != '\u0000') {
                SourceLocation startLocation = stream.getLocation();
                stream.next();
                int escapeChar = 92;
                StringBuilder builder = new StringBuilder();
                boolean lastWasEscape = false;
                while (!stream.isEof()) {
                    char curChar = stream.next();
                    if (curChar == '\\') {
                        if (lastWasEscape) {
                            builder.append('\\');
                            lastWasEscape = false;
                            continue;
                        }
                        lastWasEscape = true;
                        continue;
                    }
                    if (lastWasEscape) {
                        if (curChar == mode) {
                            builder.append(curChar);
                        } else {
                            builder.append('\\');
                            builder.append(curChar);
                        }
                    } else {
                        if (curChar == mode) {
                            return stream.newToken(tokenType, startLocation, builder.toString());
                        }
                        builder.append(curChar);
                    }
                    lastWasEscape = false;
                }
                throw new LexerException(LexerProblems.get().eofInString(stream.getIndex()));
            }
            return null;
        };
    }

    public static LexingMatcher forLineComment(String startsWith) {
        return (type, stream) -> {
            char ch;
            SourceLocation startsAt = stream.nextIf(startsWith);
            if (startsAt == null) {
                return null;
            }
            while (!stream.isEof() && (ch = stream.peek()) != '\r' && ch != '\n') {
                stream.next();
            }
            return stream.newToken(type, startsAt, "");
        };
    }

    public static boolean isIdentifierCharacter(char ch, boolean includeNumbers) {
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch == '_') {
            return true;
        }
        return includeNumbers && ch >= '0' && ch <= '9';
    }

    public static LexingMatcher forKeyword(String keywordMixedCase) {
        final String keyword = keywordMixedCase.toLowerCase();
        return new LexingMatcher(){

            @Override
            public Token match(TokenType type, LexingStream stream) {
                int matchIdx = 0;
                int len = keyword.length();
                SourceLocation startLocation = stream.getLocation();
                while (matchIdx < len) {
                    char expected = keyword.charAt(matchIdx++);
                    char ch = stream.peek();
                    if (ch != expected && Character.toLowerCase(ch) != expected) {
                        return null;
                    }
                    stream.next();
                }
                if (LexingMatcher.isIdentifierCharacter(stream.peek(), true)) {
                    return null;
                }
                return stream.newToken(type, startLocation, keyword);
            }

            @Override
            public Optional<String> getKeyword() {
                return Optional.of(keyword);
            }
        };
    }

    public Token match(TokenType var1, LexingStream var2);

    default public Optional<String> getKeyword() {
        return Optional.empty();
    }
}

