/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.ConditionalParse;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.LexerProblems;
import nz.org.riskscape.dsl.LexingStream;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.dsl.UnexpectedTokenException;
import nz.org.riskscape.engine.RiskscapeException;

public class Lexer<T extends TokenType> {
    private final LexingStream stream;
    private final Tokens<T> tokens;
    private Token peeked;
    private Token prevTokenThisLine = null;

    public Lexer(Tokens<T> tokens, String source) {
        this.tokens = tokens;
        this.stream = new LexingStream(source);
    }

    public Token next() throws LexerException {
        Token next = this.peek();
        this.peeked = null;
        return next;
    }

    public String remaining() {
        int startFrom = this.peeked == null ? this.stream.getIndex() : this.peeked.begin;
        return this.stream.getSource().substring(startFrom);
    }

    public Token peek() throws LexerException {
        block0: while (this.peeked == null) {
            if (this.stream.isEof()) {
                Token eof = Token.eof(this.tokens, this.stream.getSource());
                eof.setLocation(this.stream.getLocation());
                return eof;
            }
            SourceLocation location = this.stream.getLocation();
            for (TokenType candidate : this.tokens.getConstants()) {
                Token match = candidate.matcher().match(candidate, this.stream);
                if (match != null) {
                    if (match.begin == match.end && match.type != this.tokens.eofToken) {
                        throw new AssertionError((Object)("Zero length token - only eof can be zero length " + String.valueOf(match)));
                    }
                    if (this.tokens.newLines.contains(match.type)) {
                        this.prevTokenThisLine = null;
                    } else {
                        match.setPrevious(this.prevTokenThisLine);
                        this.prevTokenThisLine = match;
                    }
                    if (match.type.isWhitespace()) continue block0;
                    if (match.type == this.tokens.eofToken) {
                        throw new LexerException(LexerProblems.get().unexpectedEof(this.stream.getLocation()));
                    }
                    this.peeked = match;
                    return this.peeked;
                }
                this.stream.rewind(location);
            }
            throw new LexerException(LexerProblems.get().unexpectedCharacter(this.stream.getLocation(), this.stream.next()));
        }
        return this.peeked;
    }

    public boolean isEOF() throws LexerException {
        return this.peek().type == this.tokens.eofToken;
    }

    public T peekType() {
        return (T)this.peek().type;
    }

    public void rewind(Token backTo) {
        if (this.peeked != null) {
            this.peeked = null;
        }
        this.prevTokenThisLine = backTo.getPrevious();
        this.stream.rewind(backTo.getLocation());
    }

    @SafeVarargs
    public final Token expect(TokenType ... expected) {
        HashSet expectedSet = Sets.newHashSet((Object[])expected);
        return this.expect(expectedSet);
    }

    public final Token expect(Set<? extends TokenType> expected) {
        Token got = this.next();
        if (!expected.contains(got.type)) {
            this.rewind(got);
            throw new UnexpectedTokenException(expected, got);
        }
        return got;
    }

    @SafeVarargs
    public final <U> U tryThese(ConditionalParse<U> ... attemptsArray) {
        Token startToken = this.peek();
        for (ConditionalParse<U> cp2 : attemptsArray) {
            this.rewind(startToken);
            List<Set<TokenType>> tokenSequence = cp2.getNextTokens();
            boolean matched = true;
            for (Set<TokenType> next : tokenSequence) {
                Token token = this.next();
                if (next.contains(token.type)) continue;
                matched = false;
            }
            if (!matched) continue;
            this.rewind(startToken);
            return cp2.getParse().get();
        }
        this.rewind(startToken);
        List<ConditionalParse<U>> attempts = Arrays.asList(attemptsArray);
        int maxLen = attempts.stream().map(cp -> cp.getNextTokens().size()).max(Integer::compareTo).orElseThrow(() -> new IllegalArgumentException("conditions had empty tokens"));
        int counter = 0;
        while (counter < maxLen) {
            Token currentToken = this.next();
            int finalCounter = counter++;
            attempts.removeIf(cp -> cp.getNextTokens().size() <= finalCounter);
            List<ConditionalParse> matching = attempts.stream().collect(Collectors.partitioningBy(cp -> cp.getNextTokens().get(finalCounter).contains(currentToken.type))).get(Boolean.TRUE);
            if (matching.size() == 0) {
                HashSet expected = Sets.newHashSet();
                attempts.forEach(cp -> expected.addAll((Collection)cp.getNextTokens().get(finalCounter)));
                this.rewind(startToken);
                throw new UnexpectedTokenException(expected, currentToken);
            }
            attempts = matching;
        }
        throw new RiskscapeException("Ambiguous ast - " + String.valueOf(attempts));
    }

    public Optional<Token> consumeIf(TokenType conditionalToken) {
        return this.consumeIf(Sets.newHashSet((Object[])new TokenType[]{conditionalToken}));
    }

    public Optional<Token> consumeIf(Set<? extends TokenType> oneOf) {
        if (oneOf.contains(this.peekType())) {
            return Optional.of(this.next());
        }
        return Optional.empty();
    }

    public static class Tokens<T extends TokenType> {
        public final Class<T> enumClass;
        public final T eofToken;
        public final List<T> newLines;

        public T[] getConstants() {
            return (TokenType[])this.enumClass.getEnumConstants();
        }

        @Generated
        public Tokens(Class<T> enumClass, T eofToken, List<T> newLines) {
            this.enumClass = enumClass;
            this.eofToken = eofToken;
            this.newLines = newLines;
        }
    }
}

