/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.dsl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.TokenType;

public class ConditionalParse<T> {
    private final String name;
    private final List<Set<? extends TokenType>> nextTokens;
    private final Supplier<T> parse;

    public static <T> ConditionalParse<T> parseIf(String name, List<Set<? extends TokenType>> nextTokens, Supplier<T> callback) {
        return new ConditionalParse<T>(name, nextTokens, callback);
    }

    public static <T> ConditionalParse<T> parseIfOneOf(String name, Set<? extends TokenType> nextTokens, Supplier<T> callback) {
        return new ConditionalParse<T>(name, Collections.singletonList(nextTokens), callback);
    }

    public static <T> ConditionalParse<T> parseIfIs(String name, TokenType nextToken, Supplier<T> callback) {
        return new ConditionalParse<T>(name, Collections.singletonList(Collections.singleton(nextToken)), callback);
    }

    public static <T> ConditionalParse<T> parseIfIs(String name, List<? extends TokenType> nextTokens, Supplier<T> callback) {
        List<Set<? extends TokenType>> list = nextTokens.stream().map(nt -> Collections.singleton(nt)).collect(Collectors.toList());
        return new ConditionalParse<T>(name, list, callback);
    }

    @Generated
    public ConditionalParse(String name, List<Set<? extends TokenType>> nextTokens, Supplier<T> parse) {
        this.name = name;
        this.nextTokens = nextTokens;
        this.parse = parse;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Set<? extends TokenType>> getNextTokens() {
        return this.nextTokens;
    }

    @Generated
    public Supplier<T> getParse() {
        return this.parse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionalParse)) {
            return false;
        }
        ConditionalParse other = (ConditionalParse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Set<TokenType>> this$nextTokens = this.getNextTokens();
        List<Set<TokenType>> other$nextTokens = other.getNextTokens();
        if (this$nextTokens == null ? other$nextTokens != null : !((Object)this$nextTokens).equals(other$nextTokens)) {
            return false;
        }
        Supplier<T> this$parse = this.getParse();
        Supplier<T> other$parse = other.getParse();
        return !(this$parse == null ? other$parse != null : !this$parse.equals(other$parse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConditionalParse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Set<TokenType>> $nextTokens = this.getNextTokens();
        result = result * 59 + ($nextTokens == null ? 43 : ((Object)$nextTokens).hashCode());
        Supplier<T> $parse = this.getParse();
        result = result * 59 + ($parse == null ? 43 : $parse.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConditionalParse(name=" + this.getName() + ", nextTokens=" + String.valueOf(this.getNextTokens()) + ", parse=" + String.valueOf(this.getParse()) + ")";
    }
}

