/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.config.ConfigProblems;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class ConfigSection {
    private final URI location;
    private final String name;

    public static Map<String, List<?>> wild(Map<String, List<String>> multiMap) {
        Map<String, List<?>> ungeneric = multiMap;
        return ungeneric;
    }

    public boolean hasKey(String key) {
        return this.getAll(key).size() > 0;
    }

    public ResultOrProblems<String> getOneRequired(String key) {
        Parameter parameter = Parameter.required(key, Object.class);
        return this.getOne(key).orElse(ResultOrProblems.failed(GeneralProblems.get().required(parameter)));
    }

    public Optional<ResultOrProblems<String>> getOne(String key) {
        List<String> values = this.getAll(key);
        if (values == null || values.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(ResultOrProblems.of(values.get(values.size() - 1), values.size() == 1 ? Collections.emptyList() : Collections.singletonList(ConfigProblems.get().duplicateKey(this.getLocation(), this.getName(), key))));
    }

    public List<String> getAll(String key) {
        return this.toMultiMap().getOrDefault(key, List.of());
    }

    public Map<String, String> toMap() {
        return Maps.transformValues(this.toMultiMap(), values -> {
            if (values == null) {
                return null;
            }
            if (values.size() == 0) {
                return null;
            }
            return (String)values.get(values.size() - 1);
        });
    }

    public Map<String, List<String>> toMultiMap() {
        Map<ConfigString, List<ConfigString>> configMap = this.toConfigMap();
        LinkedHashMap<String, List<String>> multiMap = new LinkedHashMap<String, List<String>>(configMap.size());
        for (Map.Entry<ConfigString, List<ConfigString>> entry : configMap.entrySet()) {
            multiMap.put(entry.getKey().toString(), entry.getValue().stream().map(ConfigString::toString).toList());
        }
        return multiMap;
    }

    public abstract Map<ConfigString, List<ConfigString>> toConfigMap();

    public boolean equals(Object obj) {
        if (obj instanceof ConfigSection) {
            ConfigSection rhs = (ConfigSection)obj;
            return rhs.name.equals(this.name) && rhs.toMultiMap().equals(this.toMultiMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.toMultiMap());
    }

    @Generated
    public ConfigSection(URI location, String name) {
        this.location = location;
        this.name = name;
    }

    @Generated
    public URI getLocation() {
        return this.location;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

