/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.RiskscapeException;

public class ReflectionUtils {
    public static List<Field> getAnnotatedFields(Class<?> parameterClass, Class<? extends Annotation> annotationClass) {
        List<Field> annotated = Arrays.asList(parameterClass.getDeclaredFields()).stream().filter(field -> field.isAnnotationPresent(annotationClass)).collect(Collectors.toList());
        Class<?> superClass = parameterClass.getSuperclass();
        if (superClass != null) {
            List<Field> extra = ReflectionUtils.getAnnotatedFields(superClass, annotationClass);
            extra.addAll(annotated);
            return extra;
        }
        return annotated;
    }

    public static List<Class<?>> getInterfaces(Class<?> clazz) {
        ArrayList interfaces = Lists.newArrayList();
        while (clazz != Object.class) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static Optional<Class<?>> findCommonAncestorOfType(Class<?> lhs, Class<?> rhs, Class<?> lookFor) {
        Class<?> rhsPtr;
        Class<?> lhsPtr;
        Iterator<Class<?>> lhsHierarchy = ReflectionUtils.hierarchy(lhs).iterator();
        Iterator<Class<?>> rhsHierarchy = ReflectionUtils.hierarchy(rhs).iterator();
        ArrayList members = Lists.newArrayList();
        while (lhsHierarchy.hasNext() && rhsHierarchy.hasNext() && (lhsPtr = lhsHierarchy.next()).equals(rhsPtr = rhsHierarchy.next())) {
            members.add(lhsPtr);
        }
        Collections.reverse(members);
        for (Class ancestor : members) {
            if (!ancestor.equals(lookFor) && !Sets.newHashSet((Object[])ancestor.getInterfaces()).contains(lookFor)) continue;
            return Optional.of(ancestor);
        }
        return Optional.empty();
    }

    private static List<Class<?>> hierarchy(Class<?> class3) {
        ArrayList toReturn = new ArrayList();
        Class<?> ptr = class3;
        do {
            toReturn.add(ptr);
        } while ((ptr = ptr.getSuperclass()) != null);
        Collections.reverse(toReturn);
        return toReturn;
    }

    public static <T> Class<? extends T> findImplementingClass(Class<T> iface, Class<? extends T> search, SearchOptions ... optionsArray) {
        List<SearchOptions> options = Arrays.asList(optionsArray);
        ArrayList toSearch = new ArrayList();
        toSearch.add(search);
        HashSet<Class> found = new HashSet<Class>();
        while (!toSearch.isEmpty()) {
            Class<?>[] interfaces;
            Class searching = (Class)toSearch.remove(0);
            Class parent = searching.getSuperclass();
            if (parent != null && parent != Object.class) {
                toSearch.add(parent);
            }
            if ((interfaces = searching.getInterfaces()) == null) continue;
            for (Class<?> candidateIface : searching.getInterfaces()) {
                if (candidateIface == iface) {
                    found.add(searching);
                    continue;
                }
                if (!options.contains((Object)SearchOptions.SEARCH_INTERFACES)) continue;
                toSearch.add(candidateIface);
            }
        }
        if (found.size() == 1) {
            return (Class)found.iterator().next();
        }
        throw new RiskscapeException(String.format("Expected class %s to implement %s exactly once but was implemented by: %s", search, iface, found));
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectionUtils.newInstance(clazz, e -> new RuntimeException("Failed to create an instance of class " + String.valueOf(clazz), (Throwable)e));
    }

    public static <T, E extends Exception> T newInstance(Class<T> clazz, Function<Exception, E> constructor) throws E {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw (Exception)constructor.apply(e);
        }
    }

    public static void setField(Field field, Object instance, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Unable to set value to field " + String.valueOf(field), e);
        }
    }

    public static Optional<Field> getPublicField(Class<?> clazz, String fieldName) {
        try {
            return Optional.of(clazz.getField(fieldName));
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    public static <T> Class<T> findParameterClass(Class<?> subclass) {
        return ReflectionUtils.findParameterClass(subclass, 0);
    }

    public static <T> Class<T> findParameterClass(Class<?> subclass, int parameterIndex) {
        ParameterizedType genericSuperclass;
        try {
            genericSuperclass = (ParameterizedType)subclass.getGenericSuperclass();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Parameterized classes must declare a generic type: " + String.valueOf(subclass), e);
        }
        try {
            return (Class)genericSuperclass.getActualTypeArguments()[parameterIndex];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RuntimeException("Parameterized classes must declare a generic type: " + String.valueOf(subclass), ex);
        }
    }

    public static enum SearchOptions {
        SEARCH_INTERFACES;

    }
}

