/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.mosaic;

import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.mosaic.MosaicRIF;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.Tile;
import org.geotools.geopkg.TileEntry;
import org.geotools.geopkg.TileMatrix;
import org.geotools.geopkg.TileReader;
import org.geotools.geopkg.mosaic.GeoPackageFormat;
import org.geotools.geopkg.mosaic.TileImageReader;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class GeoPackageReader
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger(GeoPackageReader.class);
    protected static final int DEFAULT_TILE_SIZE = 256;
    protected static final int ZOOM_LEVEL_BASE = 2;
    protected File sourceFile;
    protected Map<String, TileEntry> tiles = new LinkedHashMap<String, TileEntry>();
    GeoPackage file;

    public GeoPackageReader(Object source, Hints hints) throws IOException {
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(this.hints);
        this.sourceFile = GeoPackageFormat.getFileFromSource(source);
        this.file = new GeoPackage(this.sourceFile, null, null, true);
        for (TileEntry tile : this.file.tiles()) {
            this.tiles.put(tile.getTableName(), tile);
        }
        this.coverageName = this.tiles.keySet().iterator().next();
        List<TileMatrix> tileMatricies = this.tiles.get(this.coverageName).getTileMatricies();
        this.numOverviews = tileMatricies.size() - 1;
        this.overViewResolutions = new double[this.numOverviews][2];
        for (int i = 0; i < tileMatricies.size() - 1; ++i) {
            TileMatrix matrix = tileMatricies.get(i);
            this.overViewResolutions[tileMatricies.size() - i - 2] = new double[]{matrix.getXPixelSize(), matrix.getYPixelSize()};
        }
    }

    public Format getFormat() {
        return new GeoPackageFormat();
    }

    @Override
    protected boolean checkName(String coverageName) {
        Utilities.ensureNonNull((String)"coverageName", (Object)coverageName);
        return this.tiles.keySet().contains(coverageName);
    }

    @Override
    public GeneralBounds getOriginalEnvelope(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return new GeneralBounds((Bounds)this.tiles.get(coverageName).getTileMatrixSetBounds());
    }

    @Override
    protected double[] getHighestRes(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        List<TileMatrix> matrices = this.tiles.get(coverageName).getTileMatricies();
        TileMatrix matrix = matrices.get(matrices.size() - 1);
        return new double[]{matrix.getXPixelSize(), matrix.getYPixelSize()};
    }

    @Override
    public GridEnvelope getOriginalGridRange(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        List<TileMatrix> matrices = this.tiles.get(coverageName).getTileMatricies();
        TileMatrix matrix = matrices.get(matrices.size() - 1);
        return new GridEnvelope2D(new Rectangle(matrix.getMatrixWidth() * matrix.getTileWidth(), matrix.getMatrixHeight() * matrix.getTileHeight()));
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        try {
            return CRS.decode("EPSG:" + this.tiles.get(coverageName).getSrid(), true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String[] getGridCoverageNames() {
        return this.tiles.keySet().toArray(new String[this.tiles.size()]);
    }

    @Override
    public int getGridCoverageCount() {
        return this.tiles.size();
    }

    @Override
    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        int topTile;
        int rightTile;
        int bottomTile;
        int leftTile;
        TileEntry entry = this.tiles.get(coverageName);
        RenderedImage image = null;
        ReferencedEnvelope resultEnvelope = null;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(coverageName);
        ReferencedEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        if (parameters != null) {
            for (GeneralParameterValue parameter : parameters) {
                ParameterValue param = (ParameterValue)parameter;
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                try {
                    requestedEnvelope = ReferencedEnvelope.create((Bounds)gg.getEnvelope(), (CoordinateReferenceSystem)gg.getCoordinateReferenceSystem()).transform(crs, true);
                }
                catch (Exception e) {
                    requestedEnvelope = null;
                }
                dim = gg.getGridRange2D().getBounds();
            }
        }
        TileMatrix bestMatrix = null;
        if (requestedEnvelope != null && dim != null) {
            double horRes = requestedEnvelope.getSpan(0) / dim.getWidth();
            double difference = Double.MAX_VALUE;
            for (TileMatrix matrix : entry.getTileMatricies()) {
                double newRes;
                double newDifference;
                if (!matrix.hasTiles() || !((newDifference = Math.abs(horRes - (newRes = matrix.getXPixelSize().doubleValue()))) < difference)) continue;
                difference = newDifference;
                bestMatrix = matrix;
            }
        }
        if (bestMatrix == null) {
            double resolution = Double.POSITIVE_INFINITY;
            for (TileMatrix matrix : entry.getTileMatricies()) {
                double newRes;
                if (!matrix.hasTiles() || !((newRes = matrix.getXPixelSize().doubleValue()) < resolution)) continue;
                resolution = newRes;
                bestMatrix = matrix;
            }
        }
        if (bestMatrix == null) {
            return null;
        }
        ReferencedEnvelope entryBounds = entry.getTileMatrixSetBounds();
        double resX = bestMatrix.getXPixelSize() * (double)bestMatrix.getTileWidth().intValue();
        double resY = bestMatrix.getYPixelSize() * (double)bestMatrix.getTileHeight().intValue();
        double offsetX = entryBounds.getMinX();
        double offsetY = entryBounds.getMaxY();
        if (requestedEnvelope != null) {
            TileBoundsCalculator tileBoundsCalculator = new TileBoundsCalculator((Envelope)requestedEnvelope, resX, resY, offsetX, offsetY).invoke();
            leftTile = tileBoundsCalculator.getLeftTile();
            bottomTile = tileBoundsCalculator.getBottomTile();
            rightTile = tileBoundsCalculator.getRightTile();
            topTile = tileBoundsCalculator.getTopTile();
        } else {
            double minX = entryBounds.getMinX();
            double maxX = entryBounds.getMaxX();
            double minY = entryBounds.getMinY();
            double maxY = entryBounds.getMaxY();
            leftTile = (int)Math.floor((minX - offsetX) / resX);
            topTile = (int)Math.floor((offsetY - maxY) / resY);
            rightTile = (int)Math.ceil((maxX - offsetX) / resX);
            bottomTile = (int)Math.ceil((offsetY - minY) / resY);
        }
        try (TileReader it = this.file.reader(entry, bestMatrix.getZoomLevel(), bestMatrix.getZoomLevel(), leftTile, rightTile, topTile, bottomTile);){
            ArrayList<ImageInTile> sources = new ArrayList<ImageInTile>();
            TileImageReader tileReader = new TileImageReader();
            while (it.hasNext()) {
                Tile tile = it.next();
                ReferencedEnvelope tileEnvelope = new ReferencedEnvelope(offsetX + (double)tile.getColumn().intValue() * resX, offsetX + (double)(tile.getColumn() + 1) * resX, offsetY - (double)(tile.getRow() + 1) * resY, offsetY - (double)tile.getRow().intValue() * resY, crs);
                if (resultEnvelope == null) {
                    resultEnvelope = tileEnvelope;
                } else {
                    resultEnvelope.expandToInclude((Envelope)tileEnvelope);
                }
                BufferedImage tileImage = tileReader.read(tile.getData());
                int posx = (tile.getColumn() - leftTile) * 256;
                int posy = (tile.getRow() - topTile) * 256;
                sources.add(new ImageInTile(tileImage, posx, posy));
            }
            it.close();
            if (sources.isEmpty()) {
                GridCoverage2D gridCoverage2D = null;
                return gridCoverage2D;
            }
            image = sources.size() == 1 ? ((ImageInTile)sources.get((int)0)).image : this.mosaicImages(sources);
        }
        return this.coverageFactory.create((CharSequence)entry.getTableName(), image, (Bounds)resultEnvelope);
    }

    private RenderedImage mosaicImages(List<ImageInTile> sources) {
        if (GeoPackageReader.uniformImages(sources.stream().map(it -> it.image).collect(Collectors.toList()))) {
            return this.mosaicUniformImages(sources);
        }
        return this.mosaicHeterogeneousImages(sources);
    }

    private OpImage mosaicUniformImages(final List<ImageInTile> sources) {
        int minx = sources.stream().mapToInt(it -> it.posx).min().getAsInt();
        int maxx = sources.stream().mapToInt(it -> it.posx + it.image.getWidth()).max().getAsInt();
        int miny = sources.stream().mapToInt(it -> it.posy).min().getAsInt();
        int maxy = sources.stream().mapToInt(it -> it.posy + it.image.getHeight()).max().getAsInt();
        int width = maxx - minx;
        int height = maxy - miny;
        List sourceImages = sources.stream().map(it -> it.image).collect(Collectors.toList());
        ImageLayout il = new ImageLayout((RenderedImage)sourceImages.get(0));
        il.setMinX(minx);
        il.setWidth(width);
        il.setHeight(height);
        il.setMinY(miny);
        il.setTileWidth(((BufferedImage)sourceImages.get(0)).getWidth());
        il.setTileHeight(((BufferedImage)sourceImages.get(0)).getHeight());
        Hints hints = new Hints(JAI.getDefaultInstance().getRenderingHints());
        hints.putAll((Map<?, ?>)GeoTools.getDefaultHints());
        return new OpImage(new Vector(sourceImages), il, (Map)hints, false){

            public Raster computeTile(int tileX, int tileY) {
                int posx = tileX * this.tileWidth + this.tileGridXOffset;
                int posy = tileY * this.tileHeight + this.tileGridYOffset;
                ImageInTile candidate = sources.stream().filter(it -> it.posx == posx && it.posy == posy).findFirst().orElse(null);
                if (candidate != null) {
                    return candidate.image.getData().createTranslatedChild(posx, posy);
                }
                WritableRaster dest = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
                BufferedImage bi = new BufferedImage(this.getColorModel(), dest, false, null);
                Graphics2D g2D = (Graphics2D)bi.getGraphics();
                g2D.setColor(Color.WHITE);
                g2D.fillRect(0, 0, bi.getWidth(), bi.getHeight());
                g2D.dispose();
                return dest;
            }

            public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
                return sourceRect;
            }

            public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
                return destRect;
            }

            public Vector<RenderedImage> getSources() {
                return super.getSources();
            }
        };
    }

    private RenderedImage mosaicHeterogeneousImages(List<ImageInTile> sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new MosaicDescriptor());
        for (ImageInTile it : sources) {
            if (it.posx != 0 || it.posy != 0) {
                ImageWorker iw = new ImageWorker(it.image);
                iw.translate(it.posx, it.posy, Interpolation.getInstance((int)0));
                RenderedImage translated = iw.getRenderedImage();
                pb.addSource((Object)translated);
                continue;
            }
            pb.addSource((Object)it.image);
        }
        pb.setParameter("mosaicType", (Object)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
        pb.setParameter("sourceAlpha", null);
        pb.setParameter("sourceROI", null);
        pb.setParameter("sourceThreshold", null);
        pb.setParameter("backgroundValues", (Object)new double[]{0.0});
        pb.setParameter("nodata", null);
        Hints hints = new Hints(JAI.getDefaultInstance().getRenderingHints());
        hints.putAll((Map<?, ?>)GeoTools.getDefaultHints());
        RenderedImage image = new MosaicRIF().create((ParameterBlock)pb, (RenderingHints)hints);
        return image;
    }

    @Override
    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return this.read(this.coverageName, parameters);
    }

    @Override
    public void dispose() {
        if (this.file != null) {
            this.file.close();
        }
    }

    private static boolean uniformImages(List<RenderedImage> sources) {
        int numSources = sources.size();
        RenderedImage first = sources.get(0);
        ColorModel firstColorModel = first.getColorModel();
        SampleModel firstSampleModel = first.getSampleModel();
        ImageLayout result = new ImageLayout();
        result.setSampleModel(firstSampleModel);
        if (numSources == 1) {
            result.setColorModel(firstColorModel);
            return true;
        }
        int firstDataType = firstSampleModel.getDataType();
        int firstBands = firstSampleModel.getNumBands();
        int firstSampleSize = firstSampleModel.getSampleSize()[0];
        boolean hasIndexedColorModels = firstColorModel instanceof IndexColorModel;
        boolean hasComponentColorModels = firstColorModel instanceof ComponentColorModel;
        boolean hasPackedColorModels = firstColorModel instanceof PackedColorModel;
        boolean hasUnrecognizedColorModels = !hasComponentColorModels && !hasIndexedColorModels && !hasPackedColorModels;
        boolean hasUnsupportedTypes = false;
        int maxBands = firstBands;
        for (int i = 1; i < numSources; ++i) {
            RenderedImage source = sources.get(i);
            SampleModel sourceSampleModel = source.getSampleModel();
            ColorModel sourceColorModel = source.getColorModel();
            int sourceBands = sourceSampleModel.getNumBands();
            int sourceDataType = sourceSampleModel.getDataType();
            if (sourceDataType == 32) {
                hasUnsupportedTypes = true;
            }
            if (sourceBands > maxBands) {
                maxBands = sourceBands;
            }
            if (sourceColorModel instanceof IndexColorModel) {
                hasIndexedColorModels = true;
            } else if (sourceColorModel instanceof ComponentColorModel) {
                hasComponentColorModels = true;
            } else if (sourceColorModel instanceof PackedColorModel) {
                hasPackedColorModels = true;
            } else {
                hasUnrecognizedColorModels = true;
            }
            if (sourceDataType != firstDataType || sourceBands != firstBands) {
                return false;
            }
            for (int j = 0; j < sourceBands; ++j) {
                if (sourceSampleModel.getSampleSize(j) == firstSampleSize) continue;
                return false;
            }
        }
        if (hasUnrecognizedColorModels || hasUnsupportedTypes) {
            return false;
        }
        int colorModelsTypes = (hasIndexedColorModels ? 1 : 0) + (hasComponentColorModels ? 1 : 0) + (hasPackedColorModels ? 1 : 0);
        if (colorModelsTypes > 1) {
            return false;
        }
        if (hasIndexedColorModels) {
            return GeoPackageReader.hasUniformPalettes(sources);
        }
        return true;
    }

    private static boolean hasUniformPalettes(List<RenderedImage> sources) {
        RenderedImage first = sources.get(0);
        IndexColorModel reference = (IndexColorModel)first.getColorModel();
        int mapSize = reference.getMapSize();
        byte[] reference_reds = new byte[mapSize];
        byte[] reference_greens = new byte[mapSize];
        byte[] reference_blues = new byte[mapSize];
        byte[] reference_alphas = new byte[mapSize];
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] alphas = new byte[mapSize];
        reference.getReds(reference_reds);
        reference.getGreens(reference_greens);
        reference.getBlues(reference_blues);
        reference.getAlphas(reference_alphas);
        boolean uniformPalettes = true;
        int numSources = sources.size();
        for (int i = 1; i < numSources; ++i) {
            RenderedImage source = sources.get(i);
            IndexColorModel sourceColorModel = (IndexColorModel)source.getColorModel();
            if (reference.getNumColorComponents() != sourceColorModel.getNumColorComponents()) {
                throw new IllegalArgumentException("Cannot mosaic togheter images with index color models having different numbers of color components:\n " + reference + "\n" + sourceColorModel);
            }
            if (!reference.getColorSpace().equals(reference.getColorSpace())) {
                return false;
            }
            if (!sourceColorModel.equals(reference) || sourceColorModel.getMapSize() != mapSize) {
                uniformPalettes = false;
                break;
            }
            sourceColorModel.getReds(reds);
            sourceColorModel.getGreens(greens);
            sourceColorModel.getBlues(blues);
            sourceColorModel.getAlphas(alphas);
            if (Arrays.equals(reds, reference_reds) && Arrays.equals(greens, reference_greens) && Arrays.equals(blues, reference_blues) && Arrays.equals(alphas, reference_alphas)) continue;
            uniformPalettes = false;
            break;
        }
        return uniformPalettes;
    }

    private static class ImageInTile {
        BufferedImage image;
        int posx;
        int posy;

        public ImageInTile(BufferedImage image, int posX, int posY) {
            this.image = image;
            this.posx = posX;
            this.posy = posY;
        }
    }

    private class TileBoundsCalculator {
        private Envelope requestedEnvelope;
        private double resX;
        private double resY;
        private double offsetX;
        private double offsetY;
        private int leftTile;
        private int bottomTile;
        private int rightTile;
        private int topTile;

        public TileBoundsCalculator(Envelope requestedEnvelope, double resX, double resY, double offsetX, double offsetY) {
            this.requestedEnvelope = requestedEnvelope;
            this.resX = resX;
            this.resY = resY;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public int getLeftTile() {
            return this.leftTile;
        }

        public int getBottomTile() {
            return this.bottomTile;
        }

        public int getRightTile() {
            return this.rightTile;
        }

        public int getTopTile() {
            return this.topTile;
        }

        public TileBoundsCalculator invoke() {
            double minX = this.requestedEnvelope.getMinX();
            double maxX = this.requestedEnvelope.getMaxX();
            double minY = this.requestedEnvelope.getMinY();
            double maxY = this.requestedEnvelope.getMaxY();
            this.leftTile = (int)Math.floor((minX - this.offsetX) / this.resX);
            this.topTile = (int)Math.floor((this.offsetY - maxY) / this.resY);
            this.rightTile = (int)Math.ceil((maxX - this.offsetX) / this.resX);
            if (this.offsetX + (double)this.rightTile * this.resX > maxX) {
                --this.rightTile;
            }
            this.bottomTile = (int)Math.ceil((this.offsetY - minY) / this.resY);
            if (this.offsetY - (double)this.bottomTile * this.resY < minY) {
                --this.bottomTile;
            }
            return this;
        }
    }
}

