/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.jython;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import nz.org.riskscape.config.ConfigUtils;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.function.FunctionProvider;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.jython.JythonFactory;
import nz.org.riskscape.jython.JythonFunctionFramework;
import nz.org.riskscape.jython.JythonScriptException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class Plugin
extends nz.org.riskscape.engine.plugin.Plugin
implements FunctionProvider {
    public Plugin(@NonNull PluginDescriptor pDescriptor) {
        super(pDescriptor);
        if (pDescriptor == null) {
            throw new NullPointerException("pDescriptor is marked non-null but is null");
        }
    }

    public List<Problem> initializeEngine(Engine engine) {
        engine.getFunctionFrameworks().add((Identified)new JythonFunctionFramework());
        return Collections.emptyList();
    }

    public List<Problem> initializeProject(Project project, Engine enine) {
        return Collections.emptyList();
    }

    public void addFunctions(Project project, Consumer<Problem> problemSink) {
        try (JythonFactory factory = new JythonFactory(project);){
            ConfigUtils.getResources((Project)project, problemSink, cs -> cs.getName().startsWith("project"), (String)"functions").filter(r -> r.getLocation().getPath().endsWith(".py")).forEach(resource -> {
                try {
                    String id = factory.getFunctionID((Resource)resource);
                    project.getFunctionSet().add(id, resource, () -> factory.buildFunction(id, (Resource)resource));
                }
                catch (JythonScriptException ex) {
                    problemSink.accept(GeneralProblems.get().badResource(IdentifiedFunction.class, resource.getLocation()).withChildren(new Problems[]{ex.getProblem()}));
                }
            });
        }
    }
}

