/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.jython;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.jython.JythonProblems;
import nz.org.riskscape.jython.ProblemCodes;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIndentationError;
import org.python.core.PySyntaxError;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class JythonScriptException
extends RiskscapeException {
    private final Object typeOfThing;
    private final URI source;
    private final Problem causeProblem;

    private static Problem problemFromPyException(PyException cause) {
        if (cause instanceof PySyntaxError) {
            return Problem.error((String)JythonScriptException.descriptionFromPySyntaxError((PySyntaxError)cause), (Object[])new Object[0]);
        }
        if (cause instanceof PyIndentationError) {
            return Problem.error((String)JythonScriptException.descriptionFromPyIndentationError((PyIndentationError)cause), (Object[])new Object[0]);
        }
        if (Py.ImportError.equals((Object)cause.type)) {
            return JythonScriptException.toProblem(cause).withChildren(new Problems[]{JythonProblems.get().importErrorTip()});
        }
        return JythonScriptException.toProblem(cause);
    }

    public static Problem toProblem(PyException cause) {
        String type = cause.type instanceof PyType ? ((PyType)cause.type).getName() : Objects.toString(cause.type, "<unknown>");
        String reason = cause.value.toString();
        ArrayList<Problem> children = new ArrayList<Problem>();
        if (cause.getCause() instanceof RiskscapeException) {
            reason = "";
            children.add(Problems.caught((Throwable)cause.getCause()));
        }
        if (cause.traceback != null) {
            int lineno = cause.traceback.tb_lineno;
            String filename = cause.traceback.tb_frame.f_code.co_filename;
            return Problem.error((ProblemCode)ProblemCodes.EXCEPTION, (Object[])new Object[]{type.toString(), reason, filename, lineno}).withChildren(children);
        }
        return Problem.error((ProblemCode)ProblemCodes.EXCEPTION_NO_CAUSE, (Object[])new Object[]{type.toString(), reason}).withChildren(children);
    }

    private static String descriptionFromPyIndentationError(PyIndentationError cause) {
        String type = "IndentationError";
        PyTuple value = (PyTuple)cause.value;
        String message = (String)value.get(0);
        PyTuple details = (PyTuple)value.get(1);
        String filename = (String)details.get(0);
        Integer lineno = (Integer)details.get(1);
        Integer column = (Integer)details.get(2);
        return String.format("%s: %s - File \"%s\", line %d, position %d", type, message, filename, lineno, column);
    }

    public static String descriptionFromPySyntaxError(PySyntaxError cause) {
        String type = "SyntaxError";
        PyTuple value = (PyTuple)cause.value;
        String message = (String)value.get(0);
        PyTuple details = (PyTuple)value.get(1);
        String filename = (String)details.get(0);
        Integer lineno = (Integer)details.get(1);
        Integer column = (Integer)details.get(2);
        return String.format("%s: %s - File \"%s\", line %d, position %d", type, message, filename, lineno, column);
    }

    public JythonScriptException(Object typeOfThing, URI source, Exception cause) {
        super(cause.toString(), (Throwable)cause);
        this.typeOfThing = typeOfThing;
        this.source = source;
        this.causeProblem = cause instanceof PyException ? JythonScriptException.problemFromPyException((PyException)cause) : Problems.caught((Throwable)cause);
    }

    public JythonScriptException(Object typeOfThing, URI source, Problem cause) {
        super((Problems)cause);
        this.typeOfThing = typeOfThing;
        this.source = source;
        this.causeProblem = cause;
    }

    public Problem getProblem() {
        return ((JythonProblems)Problems.get(JythonProblems.class)).couldNotCreateThing(this.typeOfThing, this.source).withChildren(new Problems[]{this.causeProblem});
    }

    @Generated
    public Object getTypeOfThing() {
        return this.typeOfThing;
    }

    @Generated
    public URI getSource() {
        return this.source;
    }

    @Generated
    public Problem getCauseProblem() {
        return this.causeProblem;
    }
}

