/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.jython;

import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionCallException;
import nz.org.riskscape.engine.function.JavaFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.jython.JavaJythonHelpers;
import nz.org.riskscape.jython.JythonScriptException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyObject;

public class JythonRiskscapeFunctionDelegate
implements JavaFunction.Delegate,
JavaJythonHelpers {
    private final PyFunction function;
    private final String id;
    private final Type returnType;
    private final ArgumentList arguments;

    public Object apply(List<Object> args) {
        PyObject functionResult = null;
        try {
            PyObject[] pyArgs = new PyObject[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                Object arg = args.get(i);
                if (arg instanceof Tuple) {
                    Tuple t = (Tuple)arg;
                    arg = t.toMap();
                }
                pyArgs[i] = Py.java2py((Object)arg);
            }
            functionResult = this.function.__call__(pyArgs);
        }
        catch (PyException t) {
            throw new FunctionCallException(((LocalProblems)Problems.get(LocalProblems.class)).executionError(this.id).withChildren(new Problems[]{JythonScriptException.toProblem(t)}), (Exception)((Object)t));
        }
        if (functionResult == null) {
            throw new RuntimeException(String.format("Python function %s did not return a result", this.id));
        }
        return this.returnType.coerce(this.convertFromPython(functionResult, this.getReturnType()));
    }

    @Generated
    public JythonRiskscapeFunctionDelegate(PyFunction function, String id, Type returnType, ArgumentList arguments) {
        this.function = function;
        this.id = id;
        this.returnType = returnType;
        this.arguments = arguments;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem executionError(String var1);
    }
}

