/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.jython;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.function.FunctionFramework;
import nz.org.riskscape.engine.function.FunctionFrameworkSupport;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.MetadataParams;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.jython.JythonFactory;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class JythonFunctionFramework
implements FunctionFramework,
FunctionFrameworkSupport {
    private final String id = "jython";
    private final JavaParameterSet<MetadataParams> parameterSet = JavaParameterSet.fromBindingClass(MetadataParams.class);

    public ResultOrProblems<IdentifiedFunction> build(String functionName, Project project, BoundParameters bound) {
        MetadataParams params = (MetadataParams)this.parameterSet.bindToObject(bound).getBoundToObject();
        try (JythonFactory factory = new JythonFactory(project);){
            ResultOrProblems resultOrProblems = this.loadFunctionFromParams(project.getEngine(), params).flatMap(resource -> factory.buildFunction((Resource)resource, params.toFunctionMetadata(functionName))).composeProblems(Problems.foundWith(IdentifiedFunction.class, (String)functionName, (Problem[])new Problem[0]));
            return resultOrProblems;
        }
    }

    public boolean canBuild(Project project, Map<String, List<?>> unbound) {
        return MetadataParams.locationEndsWith(unbound, (String)".py");
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public JavaParameterSet<MetadataParams> getParameterSet() {
        return this.parameterSet;
    }
}

