/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.jython;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.jython.JavaJythonHelpers;
import nz.org.riskscape.jython.JythonProblems;
import nz.org.riskscape.jython.JythonRealizableFunction;
import nz.org.riskscape.jython.JythonRiskscapeFunctionDelegate;
import nz.org.riskscape.jython.JythonScriptException;
import nz.org.riskscape.jython.NestedFunction;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonFactory
implements Closeable,
AutoCloseable,
JavaJythonHelpers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JythonFactory.class);
    private static final Object FUNCTION_OBJECT = JythonRiskscapeFunctionDelegate.class;
    public static final IdentifiedFunction.Category DEFAULT_CATEGORY = IdentifiedFunction.Category.UNASSIGNED;
    private static final Predicate<String> ID_PATTERN_PRESENCE = Pattern.compile("^\\h*ID\\h*=\\h*").asPredicate();
    private static final Pattern ID_PATTERN_SINGLE_QUOTES = Pattern.compile("^\\h*ID\\h*=\\h*\\'(?<ID>.+)'\\h*$");
    private static final Pattern ID_PATTERN_DOUBLE_QUOTES = Pattern.compile("^\\h*ID\\h*=\\h*\\\"(?<ID>.+)\"\\h*$");
    private PythonInterpreter interpreter;
    private TypeSet typeSet;
    private Map<String, NestedFunction> pythonFunctionMap;
    private Project project;

    public JythonFactory(final Project project) {
        this.project = project;
        this.initialize();
        this.pythonFunctionMap = new AbstractMap<String, NestedFunction>(){

            @Override
            public Set<Map.Entry<String, NestedFunction>> entrySet() {
                return Collections.emptySet();
            }

            @Override
            public NestedFunction get(Object key) {
                IdentifiedFunction function = (IdentifiedFunction)project.getFunctionSet().get(key.toString(), project.getEngine().getProblemSink());
                return new NestedFunction((RiskscapeFunction)function);
            }
        };
        this.interpreter = new PythonInterpreter();
        this.typeSet = project.getTypeSet();
    }

    private void initialize() {
        Properties props = new Properties();
        props.put("python.import.site", "false");
        File jythonHome = new File(System.getProperty("user.home"), ".riskscape-jython");
        if (!jythonHome.exists()) {
            jythonHome.mkdir();
        }
        props.setProperty("python.home", jythonHome.toString());
        Properties preprops = System.getProperties();
        PythonInterpreter.initialize((Properties)preprops, (Properties)props, (String[])new String[0]);
    }

    private PyObject loadGlobals(Resource resource) {
        Reader reader = resource.getContentReader();
        log.info("Loading function from: {}", (Object)resource.getLocation());
        PyObject globals = this.compileToGlobals(reader, resource.getLocation(), FUNCTION_OBJECT);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new JythonScriptException(FUNCTION_OBJECT, resource.getLocation(), e);
        }
        return globals;
    }

    public ResultOrProblems<IdentifiedFunction> buildFunction(String functionId, Resource resource) {
        try {
            PyObject globals = this.loadGlobals(resource);
            Optional<PyFunction> functionDefinition = this.findItem(globals, "function", PyFunction.class, FUNCTION_OBJECT, resource.getLocation());
            if (functionDefinition.isPresent()) {
                FunctionMetadata metadata = this.snoopFunctionMetadata(functionId, globals, resource.getLocation());
                return ResultOrProblems.of((Object)this.buildFunction(functionDefinition.get(), metadata, resource));
            }
            return ResultOrProblems.of((Object)this.wrapRiskscapeFunction(functionId, globals, resource.getLocation()));
        }
        catch (JythonScriptException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().badResource(IdentifiedFunction.class, resource.getLocation()).withChildren(new Problems[]{ex.getProblem()})});
        }
    }

    public ResultOrProblems<IdentifiedFunction> buildFunction(Resource resource, FunctionMetadata metadata) {
        Problem badFunction = GeneralProblems.get().badResource(IdentifiedFunction.class, resource.getLocation());
        try {
            PyObject globals;
            try {
                globals = this.loadGlobals(resource);
            }
            catch (RiskscapeIOException e) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
            }
            Optional<PyFunction> functionDefinition = this.findItem(globals, "function", PyFunction.class, FUNCTION_OBJECT, resource.getLocation());
            if (!functionDefinition.isPresent()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{badFunction.withChildren(new Problems[]{JythonProblems.get().mustHaveFunction()})});
            }
            return ResultOrProblems.of((Object)this.buildFunction(functionDefinition.get(), metadata, resource));
        }
        catch (JythonScriptException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{badFunction.withChildren(new Problems[]{ex.getProblem()})});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getFunctionID(Resource resource) {
        try (BufferedReader reader = new BufferedReader(resource.getContentReader());){
            String id;
            block11: {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!ID_PATTERN_PRESENCE.test(line)) continue;
                    id = this.extractID(line, ID_PATTERN_SINGLE_QUOTES);
                    if (id == null) {
                        id = this.extractID(line, ID_PATTERN_DOUBLE_QUOTES);
                    }
                    if (id == null) {
                        continue;
                    }
                    break block11;
                }
                throw new JythonScriptException(FUNCTION_OBJECT, resource.getLocation(), JythonProblems.get().missingConstant("function", "ID"));
            }
            String string = id;
            return string;
        }
        catch (IOException e) {
            throw new JythonScriptException(FUNCTION_OBJECT, resource.getLocation(), e);
        }
    }

    private String extractID(String lineFromScript, Pattern pattern) {
        Matcher matcher = pattern.matcher(lineFromScript);
        if (matcher.matches()) {
            return matcher.group("ID");
        }
        return null;
    }

    private FunctionMetadata snoopFunctionMetadata(String functionId, PyObject globals, URI pathToScript) {
        String description = this.findItem(globals, "DESCRIPTION", PyString.class, FUNCTION_OBJECT, pathToScript).map(d -> d.toString()).orElse("");
        PyList arguments = this.findRequiredItem(globals, "ARGUMENT_TYPES", PyList.class, FUNCTION_OBJECT, pathToScript);
        ArrayList argumentTypes = Lists.newArrayList();
        for (Object rawArgument : arguments) {
            argumentTypes.add(this.toType(rawArgument, "function", pathToScript, "ARGUMENT_TYPES members"));
        }
        Type returnType = this.toType(this.findRequiredItem(globals, "RETURN_TYPE", PyObject.class, "function", pathToScript).__tojava__(Object.class), "function", pathToScript, "RETURN_TYPE");
        Optional<PyString> categoryString = this.findItem(globals, "CATEGORY", PyString.class, FUNCTION_OBJECT, pathToScript);
        IdentifiedFunction.Category category = categoryString.map(cat -> {
            String catName = cat.toString().toUpperCase();
            try {
                return IdentifiedFunction.Category.valueOf((String)catName);
            }
            catch (IllegalArgumentException e) {
                throw new JythonScriptException((Object)"CATEGORY", pathToScript, GeneralProblems.get().notAnOption(catName, IdentifiedFunction.Category.class, Arrays.asList(IdentifiedFunction.Category.values())));
            }
        }).orElse(DEFAULT_CATEGORY);
        return new FunctionMetadata(functionId, (List)argumentTypes, returnType, description, category, pathToScript);
    }

    private IdentifiedFunction buildFunction(PyFunction pythonFunction, FunctionMetadata metadata, Resource source) {
        return new JythonRealizableFunction(metadata, source, pythonFunction).identified();
    }

    private IdentifiedFunction wrapRiskscapeFunction(String functionId, PyObject globals, URI pathToScript) {
        String description = this.findItem(globals, "DESCRIPTION", PyString.class, FUNCTION_OBJECT, pathToScript).map(d -> d.toString()).orElse("");
        RiskscapeFunction exportedFunction = (RiskscapeFunction)this.findItem(globals, "FUNCTION", PyObject.class, FUNCTION_OBJECT, pathToScript).orElseThrow(() -> new JythonScriptException(FUNCTION_OBJECT, pathToScript, JythonProblems.get().missingFunctionObject())).__tojava__(RiskscapeFunction.class);
        return exportedFunction.identified(functionId, description, pathToScript, DEFAULT_CATEGORY);
    }

    private Type toType(Object rawArgument, String typeOfThing, URI source, String explanation) {
        if (rawArgument instanceof String) {
            try {
                return this.typeSet.getRequired(rawArgument.toString());
            }
            catch (MissingTypeException e) {
                throw new JythonScriptException((Object)explanation, source, e.getProblem());
            }
        }
        if (rawArgument instanceof Type) {
            return (Type)rawArgument;
        }
        throw new JythonScriptException((Object)typeOfThing, source, JythonProblems.get().thingWasWrongType(explanation, rawArgument.getClass()));
    }

    public Type createType(Resource resource) {
        log.info("Loading type from: {}", (Object)resource.getLocation());
        PyObject globals = this.compileToGlobals(resource.getContentReader(), resource.getLocation(), "type");
        PyString id = this.findRequiredItem(globals, "ID", PyString.class, "type", resource.getLocation());
        PyObject type = this.findRequiredItem(globals, "TYPE", PyObject.class, "type", resource.getLocation());
        try {
            Type toAdd = (Type)type.__tojava__(Type.class);
            this.typeSet.addType(id.getString(), resource, () -> ResultOrProblems.of((Object)toAdd));
            return toAdd;
        }
        catch (ClassCastException e) {
            throw new JythonScriptException((Object)"type", resource.getLocation(), JythonProblems.get().couldNotConvertToType().withChildren(new Problems[]{Problems.caught((Throwable)e)}));
        }
    }

    protected IdentifiedType extractType(String functionId, PyObject globals, String prefix, URI scriptSource) {
        Optional<PyString> typeId = this.findItem(globals, prefix + "_TYPE_ID", PyString.class, "type", scriptSource);
        Optional<PyObject> typeObject = this.findItem(globals, prefix + "_TYPE", PyObject.class, "type", scriptSource);
        if (typeId.isPresent() && typeObject.isPresent()) {
            throw new RuntimeException("Function has defined an id and a type for for " + prefix + ". Only one is allowed");
        }
        if (!typeId.isPresent() && !typeObject.isPresent()) {
            throw new RuntimeException("Function has defined neither id or type for for " + prefix + ". One of these must be defined");
        }
        if (typeId.isPresent()) {
            return this.typeSet.getLinkedType(typeId.get().toString());
        }
        try {
            Type type = (Type)typeObject.get().__tojava__(Type.class);
            String fakeId = functionId + "_" + prefix + "_ANON";
            return this.typeSet.add(fakeId, type);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(prefix + "_TYPE is not a Type object", ex);
        }
    }

    private PyObject compileToGlobals(Reader script, URI source, Object typeOfThing) {
        PyCode compiled;
        try {
            compiled = this.interpreter.compile(script, source.getPath());
        }
        catch (PyException ex) {
            throw new JythonScriptException(typeOfThing, source, (Exception)((Object)ex));
        }
        PyStringMap globals = Py.newStringMap();
        globals.__setitem__("typeset", PyJavaType.wrapJavaObject((Object)this.typeSet));
        globals.__setitem__("functions", PyJavaType.wrapJavaObject(this.pythonFunctionMap));
        globals.__setitem__("nested_function", this.toPyCallable(RiskscapeFunction.class, NestedFunction.class, rsFunction -> new NestedFunction((RiskscapeFunction)rsFunction)));
        try {
            Py.exec((PyObject)compiled, (PyObject)globals, (PyObject)globals);
        }
        catch (PyException ex) {
            throw new JythonScriptException(typeOfThing, source, (Exception)((Object)ex));
        }
        return globals;
    }

    protected <T extends PyObject> Optional<T> findItem(PyObject source, String key, Class<T> clazz, Object typeOfThing, URI scriptSource) {
        PyObject item = source.__finditem__(key.intern());
        if (item == null) {
            return Optional.empty();
        }
        if (!clazz.isInstance(item)) {
            throw new JythonScriptException(typeOfThing, scriptSource, JythonProblems.get().unexpectedType(key, clazz, item.getClass()));
        }
        PyObject cast = item;
        return Optional.of(cast);
    }

    protected <T extends PyObject> T findRequiredItem(PyObject source, String key, Class<T> clazz, Object typeOfThing, URI scriptSource) {
        return (T)((PyObject)this.findItem(source, key, clazz, typeOfThing, scriptSource).orElseThrow(() -> new JythonScriptException(typeOfThing, scriptSource, JythonProblems.get().missingConstant(typeOfThing, key))));
    }

    @Override
    public void close() {
        this.interpreter.close();
    }
}

