/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.jython;

import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;

public interface JavaJythonHelpers {
    default public Object convertFromPython(PyObject ob, Type type) {
        Tuple convertedValue;
        if (ob instanceof PyBoolean) {
            convertedValue = Boolean.valueOf(((PyBoolean)ob).getBooleanValue());
        } else if (ob instanceof PyInteger) {
            convertedValue = Integer.valueOf(((PyInteger)ob).getValue());
        } else if (ob instanceof PyFloat) {
            convertedValue = Double.valueOf(((PyFloat)ob).getValue());
        } else if (ob instanceof PyString) {
            convertedValue = ((PyString)ob).getString();
        } else if (ob instanceof PyDictionary) {
            ConcurrentMap returned = ((PyDictionary)ob).getMap();
            if (type.getUnwrappedType() instanceof Struct) {
                Struct struct = (Struct)type.getUnwrappedType();
                Tuple converted = new Tuple(struct);
                returned.forEach((k, v) -> {
                    String key = k.toString();
                    Type keyType = struct.getMember(key).map(Struct.StructMember::getType).orElseThrow(() -> new RuntimeException(String.format("Python object %s does not match described return type %s", ob, type)));
                    converted.set(key, keyType.coerce(this.convertFromPython((PyObject)v, keyType)));
                });
                convertedValue = converted;
            } else {
                Tuple converted = new HashMap();
                returned.forEach((k, v) -> converted.put(this.convertFromPython((PyObject)k, (Type)Types.ANYTHING).toString(), this.convertFromPython((PyObject)v, (Type)Types.ANYTHING)));
                convertedValue = converted;
            }
        } else {
            return ob.__tojava__(Object.class);
        }
        return convertedValue;
    }

    default public <X, Y> PyObject toPyCallable(final Class<X> in, Class<Y> out, final Function<X, Y> toWrap) {
        return new PyObject(){

            public PyObject __call__(PyObject[] args, String[] keywords) {
                if (keywords.length > 0) {
                    throw new RuntimeException("keywords not supported");
                }
                if (args.length != 1) {
                    throw new RuntimeException(String.format("Function %s expected exactly %d args, got %d", toWrap, 1, args.length));
                }
                Object returned = toWrap.apply(args[0].__tojava__(in));
                return Py.java2py(returned);
            }
        };
    }
}

